/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.amqp;

import jakarta.jms.Message;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.amqp.AMQPConfiguration;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPJmsBinding
extends JmsBinding {
    private static final Logger LOG = LoggerFactory.getLogger(AMQPJmsBinding.class);
    private boolean includeAmqpAnnotations;

    public AMQPJmsBinding(JmsEndpoint endpoint) {
        super(endpoint);
        JmsConfiguration jmsConfiguration = endpoint.getConfiguration();
        if (jmsConfiguration instanceof AMQPConfiguration) {
            AMQPConfiguration amqpConfiguration = (AMQPConfiguration)jmsConfiguration;
            this.includeAmqpAnnotations = amqpConfiguration.isIncludeAmqpAnnotations();
        }
    }

    @Override
    public Map<String, Object> extractHeadersFromJms(Message jmsMessage, Exchange exchange) {
        Map<String, Object> headers = super.extractHeadersFromJms(jmsMessage, exchange);
        if (!this.includeAmqpAnnotations) {
            return headers;
        }
        AmqpJmsMessageFacade facade = this.getMessageFacade(jmsMessage);
        if (facade == null) {
            return headers;
        }
        facade.filterTracingAnnotations((key, value) -> {
            LOG.trace("Extract message annotation: {} = {}", key, value);
            headers.put("JMS_AMQP_MA_" + key, value);
        });
        return headers;
    }

    private AmqpJmsMessageFacade getMessageFacade(Message message) {
        JmsMessage jmsMessage;
        if (message instanceof JmsMessage && (jmsMessage = (JmsMessage)message).getFacade() instanceof AmqpJmsMessageFacade) {
            return (AmqpJmsMessageFacade)jmsMessage.getFacade();
        }
        return null;
    }
}

