/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NamedNode;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteConfigurationsDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.DumpRoutesStrategy;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.ModelToYAMLDumper;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.ResourceSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="default-dump-routes")
public class DefaultDumpRoutesStrategy
extends ServiceSupport
implements DumpRoutesStrategy,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDumpRoutesStrategy.class);
    private static final String DIVIDER = "--------------------------------------------------------------------------------";
    private final AtomicInteger counter = new AtomicInteger();
    private CamelContext camelContext;
    private String include = "routes";
    private boolean resolvePlaceholders = true;
    private boolean uriAsParameters;
    private boolean generatedIds = true;
    private boolean log = true;
    private String output;
    private String outputFileName;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    protected void doStart() throws Exception {
        String name = FileUtil.stripPath(this.output);
        if (name != null && name.contains(".")) {
            this.outputFileName = name;
            this.output = FileUtil.onlyPath(this.output);
            if (this.output == null || this.output.isEmpty()) {
                this.output = ".";
            }
        }
    }

    @Override
    public String getInclude() {
        return this.include;
    }

    @Override
    public void setInclude(String include) {
        this.include = include;
    }

    @Override
    public boolean isResolvePlaceholders() {
        return this.resolvePlaceholders;
    }

    @Override
    public void setResolvePlaceholders(boolean resolvePlaceholders) {
        this.resolvePlaceholders = resolvePlaceholders;
    }

    @Override
    public boolean isGeneratedIds() {
        return this.generatedIds;
    }

    @Override
    public void setGeneratedIds(boolean generatedIds) {
        this.generatedIds = generatedIds;
    }

    @Override
    public boolean isLog() {
        return this.log;
    }

    @Override
    public void setLog(boolean log) {
        this.log = log;
    }

    @Override
    public String getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(String output) {
        this.output = output;
    }

    @Override
    public boolean isUriAsParameters() {
        return this.uriAsParameters;
    }

    @Override
    public void setUriAsParameters(boolean uriAsParameters) {
        this.uriAsParameters = uriAsParameters;
    }

    @Override
    public void dumpRoutes(String format) {
        if ("yaml".equalsIgnoreCase(format)) {
            this.doDumpRoutesAsYaml(this.camelContext);
        } else if ("xml".equalsIgnoreCase(format)) {
            this.doDumpRoutesAsXml(this.camelContext);
        }
    }

    protected void doDumpRoutesAsYaml(CamelContext camelContext) {
        OptionalIdentifiedDefinition rests;
        Resource resource2;
        OptionalIdentifiedDefinition def;
        OptionalIdentifiedDefinition routes;
        StringBuilder sbLocal;
        Object sbLog;
        Resource res;
        LinkedHashMap<Resource, Object> groups;
        int size;
        ModelToYAMLDumper dumper = PluginHelper.getModelToYAMLDumper(camelContext);
        Model model = camelContext.getCamelContextExtension().getContextPlugin(Model.class);
        DummyResource dummy = new DummyResource(null, null);
        HashSet<String> files = new HashSet<String>();
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("beans")) && (size = model.getCustomBeans().size()) > 0) {
            groups = new LinkedHashMap<Resource, Object>();
            for (BeanFactoryDefinition<?> beanFactoryDefinition : model.getCustomBeans()) {
                res = beanFactoryDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                List beans2 = groups.computeIfAbsent(res, resource -> new ArrayList());
                beans2.add(beanFactoryDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                List beans2 = (List)entry.getValue();
                Resource resource22 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpYamlBeans(camelContext, beans2, resource22 == dummy ? null : resource22, dumper, "beans", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource22, sbLocal, "beans", "yaml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} beans as YAML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("routes")) && (size = model.getRouteDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RouteDefinition routeDefinition : model.getRouteDefinitions()) {
                if (routeDefinition.isRest() != null && routeDefinition.isRest().booleanValue() || routeDefinition.isTemplate() != null && routeDefinition.isTemplate().booleanValue()) continue;
                res = routeDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                routes = groups.computeIfAbsent(res, resource -> new RoutesDefinition());
                ((RoutesDefinition)routes).getRoutes().add(routeDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RoutesDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpYaml(camelContext, def, resource2 == dummy ? null : resource2, dumper, "routes", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "routes", "yaml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} routes as YAML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("routeConfigurations") || this.include.contains("route-configurations")) && (size = model.getRouteConfigurationDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RouteConfigurationDefinition routeConfigurationDefinition : model.getRouteConfigurationDefinitions()) {
                res = routeConfigurationDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                routes = groups.computeIfAbsent(res, resource -> new RouteConfigurationsDefinition());
                ((RouteConfigurationsDefinition)routes).getRouteConfigurations().add(routeConfigurationDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RouteConfigurationsDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpYaml(camelContext, def, resource2 == dummy ? null : resource2, dumper, "route-configurations", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "route-configurations", "yaml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} route-configurations as YAML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("rests")) && (size = model.getRestDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RestDefinition restDefinition : model.getRestDefinitions()) {
                res = restDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                rests = groups.computeIfAbsent(res, resource -> new RestsDefinition());
                ((RestsDefinition)rests).getRests().add(restDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RestsDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpYaml(camelContext, def, resource2 == dummy ? null : resource2, dumper, "rests", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "rests", "yaml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} rests as YAML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("routeTemplates") || this.include.contains("route-templates")) && (size = model.getRouteTemplateDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RouteTemplateDefinition routeTemplateDefinition : model.getRouteTemplateDefinitions()) {
                res = routeTemplateDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                rests = groups.computeIfAbsent(res, resource -> new RouteTemplatesDefinition());
                ((RouteTemplatesDefinition)rests).getRouteTemplates().add(routeTemplateDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RouteTemplatesDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpYaml(camelContext, def, resource2 == dummy ? null : resource2, dumper, "route-templates", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "route-templates", "yaml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} route-templates as YAML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
    }

    protected void doDumpYaml(CamelContext camelContext, NamedNode def, Resource resource, ModelToYAMLDumper dumper, String kind, StringBuilder sbLocal, StringBuilder sbLog) {
        try {
            String dump = dumper.dumpModelAsYaml(camelContext, def, this.resolvePlaceholders, this.uriAsParameters, this.generatedIds);
            sbLocal.append(dump);
            this.appendLogDump(resource, dump, sbLog);
        }
        catch (Exception e) {
            LOG.warn("Error dumping {}} to YAML due to {}. This exception is ignored.", new Object[]{kind, e.getMessage(), e});
        }
    }

    protected void doDumpYamlBeans(CamelContext camelContext, List beans2, Resource resource, ModelToYAMLDumper dumper, String kind, StringBuilder sbLocal, StringBuilder sbLog) {
        try {
            String dump = dumper.dumpBeansAsYaml(camelContext, beans2);
            sbLocal.append(dump);
            this.appendLogDump(resource, dump, sbLog);
        }
        catch (Exception e) {
            LOG.warn("Error dumping {}} to YAML due to {}. This exception is ignored.", new Object[]{kind, e.getMessage(), e});
        }
    }

    protected void doDumpRoutesAsXml(CamelContext camelContext) {
        Resource resource2;
        OptionalIdentifiedDefinition def;
        OptionalIdentifiedDefinition routes;
        StringBuilder sbLocal;
        Object sbLog;
        Resource res;
        LinkedHashMap<Resource, Object> groups;
        int size;
        ModelToXMLDumper dumper = PluginHelper.getModelToXMLDumper(camelContext);
        Model model = camelContext.getCamelContextExtension().getContextPlugin(Model.class);
        DummyResource dummy = new DummyResource(null, null);
        HashSet<String> files = new HashSet<String>();
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("beans")) && (size = model.getCustomBeans().size()) > 0) {
            groups = new LinkedHashMap<Resource, Object>();
            for (BeanFactoryDefinition<?> beanFactoryDefinition : model.getCustomBeans()) {
                res = beanFactoryDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                List beans2 = groups.computeIfAbsent(res, resource -> new ArrayList());
                beans2.add(beanFactoryDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                List beans2 = (List)entry.getValue();
                Resource resource22 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpXmlBeans(camelContext, beans2, resource22 == dummy ? null : resource22, dumper, "beans", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource22, sbLocal, "beans", "xml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} beans as XML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("routes")) && (size = model.getRouteDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RouteDefinition routeDefinition : model.getRouteDefinitions()) {
                if (routeDefinition.isRest() != null && routeDefinition.isRest().booleanValue() || routeDefinition.isTemplate() != null && routeDefinition.isTemplate().booleanValue()) continue;
                res = routeDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                routes = groups.computeIfAbsent(res, resource -> new RoutesDefinition());
                ((RoutesDefinition)routes).getRoutes().add(routeDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RoutesDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpXml(camelContext, def, resource2 == dummy ? null : resource2, dumper, "route", "routes", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "routes", "xml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} routes as XML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("routeConfigurations") || this.include.contains("route-configurations")) && (size = model.getRouteConfigurationDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RouteConfigurationDefinition routeConfigurationDefinition : model.getRouteConfigurationDefinitions()) {
                res = routeConfigurationDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                routes = groups.computeIfAbsent(res, resource -> new RouteConfigurationsDefinition());
                ((RouteConfigurationsDefinition)routes).getRouteConfigurations().add(routeConfigurationDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RouteConfigurationsDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpXml(camelContext, def, resource2 == dummy ? null : resource2, dumper, "routeConfiguration", "route-configurations", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "route-configurations", "xml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} route-configurations as XML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("rests")) && (size = model.getRestDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RestDefinition restDefinition : model.getRestDefinitions()) {
                res = restDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                routes = groups.computeIfAbsent(res, resource -> new RestsDefinition());
                ((RestsDefinition)routes).getRests().add(restDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RestsDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpXml(camelContext, def, resource2 == dummy ? null : resource2, dumper, "rest", "rests", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "rests", "xml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} rests as XML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("routeTemplates") || this.include.contains("route-templates")) && (size = model.getRouteTemplateDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RouteTemplateDefinition routeTemplateDefinition : model.getRouteTemplateDefinitions()) {
                res = routeTemplateDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                routes = groups.computeIfAbsent(res, resource -> new RouteTemplatesDefinition());
                ((RouteTemplatesDefinition)routes).getRouteTemplates().add(routeTemplateDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RouteTemplatesDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpXml(camelContext, def, resource2 == dummy ? null : resource2, dumper, "routeTemplate", "route-templates", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "route-templates", "xml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} route-templates as XML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if (this.output != null && !files.isEmpty()) {
            this.doAdjustXmlFiles(files);
        }
    }

    protected void doDumpXmlBeans(CamelContext camelContext, List beans2, Resource resource, ModelToXMLDumper dumper, String kind, StringBuilder sbLocal, StringBuilder sbLog) {
        try {
            String dump = dumper.dumpBeansAsXml(camelContext, beans2);
            sbLocal.append(dump);
            this.appendLogDump(resource, dump, sbLog);
        }
        catch (Exception e) {
            LOG.warn("Error dumping {}} to XML due to {}. This exception is ignored.", new Object[]{kind, e.getMessage(), e});
        }
    }

    protected void doDumpXml(CamelContext camelContext, NamedNode def, Resource resource, ModelToXMLDumper dumper, String replace, String kind, StringBuilder sbLocal, StringBuilder sbLog) {
        try {
            String xml = dumper.dumpModelAsXml(camelContext, def, this.resolvePlaceholders, this.generatedIds);
            xml = StringHelper.replaceFirst(xml, " xmlns=\"http://camel.apache.org/schema/spring\">", ">");
            xml = xml.replace("</" + (String)replace + ">", "</" + (String)replace + ">\n");
            replace = (String)replace + "s";
            xml = StringHelper.replaceFirst(xml, "<" + (String)replace + ">", "");
            xml = StringHelper.replaceFirst(xml, "</" + (String)replace + ">", "");
            sbLocal.append(xml);
            this.appendLogDump(resource, xml, sbLog);
        }
        catch (Exception e) {
            LOG.warn("Error dumping {}} to XML due to {}. This exception is ignored.", new Object[]{kind, e.getMessage(), e});
        }
    }

    protected void doDumpToDirectory(Resource resource, StringBuilder sbLocal, String kind, String ext, Set<String> files) {
        if (this.output != null && !sbLocal.isEmpty()) {
            File dir = new File(this.output);
            dir.mkdirs();
            String name = this.resolveFileName(ext, resource);
            boolean newFile = files.isEmpty() || !files.contains(name);
            File target = new File(this.output, name);
            try {
                if (newFile) {
                    IOHelper.writeText(sbLocal.toString(), target);
                } else {
                    IOHelper.appendText(sbLocal.toString(), target);
                }
                files.add(name);
                LOG.info("Dumped {} to file: {}", (Object)kind, (Object)target);
            }
            catch (IOException e) {
                throw new RuntimeException("Error dumping " + kind + " to file: " + String.valueOf(target), e);
            }
        }
    }

    protected void doAdjustXmlFiles(Set<String> files) {
        for (String name : files) {
            if (!name.endsWith(".xml")) continue;
            try {
                File file = new File(this.output, name);
                StringBuilder sb = new StringBuilder();
                sb.append("<camel>\n\n");
                String xml = IOHelper.loadText(new FileInputStream(file));
                sb.append(xml);
                sb.append("\n</camel>\n");
                IOHelper.writeText(sb.toString(), file);
            }
            catch (Exception e) {
                LOG.warn("Error adjusting dumped XML file: {} due to {}. This exception is ignored.", new Object[]{name, e.getMessage(), e});
            }
        }
    }

    protected void appendLogDump(Resource resource, String dump, StringBuilder sbLog) {
        String loc = null;
        if (resource != null) {
            loc = DefaultDumpRoutesStrategy.extractLocationName(resource.getLocation());
        }
        if (loc != null) {
            sbLog.append(String.format("%nSource: %s%n%s%n%s%n", loc, DIVIDER, dump));
        } else {
            sbLog.append(String.format("%n%n%s%n", dump));
        }
    }

    private static String extractLocationName(String loc) {
        if (loc == null) {
            return null;
        }
        if ((loc = LoggerHelper.stripSourceLocationLineNumber(loc)) != null && loc.contains(":")) {
            loc = StringHelper.after(loc, ":", loc);
            loc = FileUtil.stripPath(loc);
        }
        return loc;
    }

    protected String resolveFileName(String ext, Resource resource) {
        Object name;
        if (this.outputFileName != null) {
            return this.outputFileName;
        }
        Object object = name = resource != null ? resource.getLocation() : null;
        if (name == null) {
            name = "dump" + this.counter.incrementAndGet();
        }
        if (((String)name).contains(":")) {
            name = StringHelper.after((String)name, ":");
        }
        return FileUtil.onlyName((String)name, true) + "." + ext;
    }

    private static final class DummyResource
    extends ResourceSupport {
        private DummyResource(String scheme, String location) {
            super(scheme, location);
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return null;
        }
    }
}

