/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerKey;
import org.apache.camel.spi.TransformerResolver;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransformerResolver
implements TransformerResolver<TransformerKey> {
    public static final String DATA_TYPE_TRANSFORMER_RESOURCE_PATH = "META-INF/services/org/apache/camel/transformer/";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTransformerResolver.class);

    @Override
    public Transformer resolve(TransformerKey key, CamelContext context) {
        String normalizedKey = this.normalize(key);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving data type transformer for key {} via: {}{}", new Object[]{key, DATA_TYPE_TRANSFORMER_RESOURCE_PATH, normalizedKey});
        }
        Optional<Transformer> transformer = this.findTransformer(normalizedKey, context);
        if (LOG.isDebugEnabled() && transformer.isPresent()) {
            LOG.debug("Found data type transformer for key {} via type: {} via: {}{}", new Object[]{key, ObjectHelper.name(transformer.getClass()), DATA_TYPE_TRANSFORMER_RESOURCE_PATH, normalizedKey});
        }
        transformer.ifPresent(t -> CamelContextAware.trySetCamelContext(t, context));
        return transformer.orElse(null);
    }

    private Optional<Transformer> findTransformer(String key, CamelContext context) {
        return context.getCamelContextExtension().getBootstrapFactoryFinder(DATA_TYPE_TRANSFORMER_RESOURCE_PATH).newInstance(key, Transformer.class);
    }
}

