/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.VariableRepository;
import org.apache.camel.spi.VariableRepositoryFactory;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.util.StringHelper;

public class RemoveVariableProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware,
CamelContextAware {
    private CamelContext camelContext;
    private String id;
    private String routeId;
    private final Expression variableName;
    private VariableRepositoryFactory factory;

    public RemoveVariableProcessor(Expression variableName) {
        this.variableName = variableName;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            String key = this.variableName.evaluate(exchange, String.class);
            String id = StringHelper.before(key, ":");
            if (id != null) {
                VariableRepository repo = this.factory.getVariableRepository(id);
                if (repo != null) {
                    key = StringHelper.after(key, ":");
                    repo.removeVariable(key);
                } else {
                    exchange.setException(new IllegalArgumentException("VariableRepository with id: " + id + " does not exist"));
                }
            } else {
                exchange.removeVariable(key);
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    @Override
    protected void doBuild() throws Exception {
        super.doBuild();
        this.factory = this.getCamelContext().getCamelContextExtension().getContextPlugin(VariableRepositoryFactory.class);
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getTraceLabel() {
        return "removeVariable[" + String.valueOf(this.variableName) + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getVariableName() {
        return this.variableName.toString();
    }
}

