/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.exceptions;

import jakarta.jms.IllegalStateException;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.InvalidClientIDRuntimeException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidDestinationRuntimeException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.InvalidSelectorRuntimeException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.JMSSecurityRuntimeException;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.MessageNotWriteableRuntimeException;
import jakarta.jms.ResourceAllocationException;
import jakarta.jms.ResourceAllocationRuntimeException;
import jakarta.jms.TransactionInProgressException;
import jakarta.jms.TransactionInProgressRuntimeException;
import jakarta.jms.TransactionRolledBackException;
import jakarta.jms.TransactionRolledBackRuntimeException;
import org.apache.qpid.jms.provider.ProviderException;

public final class JmsExceptionSupport {
    private JmsExceptionSupport() {
    }

    public static JMSException create(String message, Throwable cause) {
        if (cause instanceof JMSException) {
            return (JMSException)cause;
        }
        if (cause.getCause() instanceof JMSException) {
            return (JMSException)cause.getCause();
        }
        if (cause instanceof ProviderException) {
            return ((ProviderException)cause).toJMSException();
        }
        if ((message == null || message.isEmpty()) && ((message = cause.getMessage()) == null || message.isEmpty())) {
            message = cause.toString();
        }
        JMSException exception = new JMSException(message);
        if (cause instanceof Exception) {
            exception.setLinkedException((Exception)cause);
        }
        exception.initCause(cause);
        return exception;
    }

    public static JMSException create(Throwable cause) {
        return JmsExceptionSupport.create(null, cause);
    }

    public static MessageEOFException createMessageEOFException(Throwable cause) {
        String message = cause.getMessage();
        if (message == null || message.length() == 0) {
            message = cause.toString();
        }
        MessageEOFException exception = new MessageEOFException(message);
        if (cause instanceof Exception) {
            exception.setLinkedException((Exception)cause);
        }
        exception.initCause(cause);
        return exception;
    }

    public static MessageFormatException createMessageFormatException(Throwable cause) {
        String message = cause.getMessage();
        if (message == null || message.length() == 0) {
            message = cause.toString();
        }
        MessageFormatException exception = new MessageFormatException(message);
        if (cause instanceof Exception) {
            exception.setLinkedException((Exception)cause);
        }
        exception.initCause(cause);
        return exception;
    }

    public static JMSRuntimeException createRuntimeException(Exception exception) {
        JMSRuntimeException result = null;
        JMSException source = null;
        if (!(exception instanceof JMSException)) {
            throw new JMSRuntimeException(exception.getMessage(), null, exception);
        }
        source = (JMSException)exception;
        result = source instanceof IllegalStateException ? new IllegalStateRuntimeException(source.getMessage(), source.getErrorCode(), source) : (source instanceof InvalidClientIDException ? new InvalidClientIDRuntimeException(source.getMessage(), source.getErrorCode(), source) : (source instanceof InvalidDestinationException ? new InvalidDestinationRuntimeException(source.getMessage(), source.getErrorCode(), source) : (source instanceof InvalidSelectorException ? new InvalidSelectorRuntimeException(source.getMessage(), source.getErrorCode(), source) : (source instanceof JMSSecurityException ? new JMSSecurityRuntimeException(source.getMessage(), source.getErrorCode(), source) : (source instanceof MessageFormatException ? new MessageFormatRuntimeException(source.getMessage(), source.getErrorCode(), source) : (source instanceof MessageNotWriteableException ? new MessageNotWriteableRuntimeException(source.getMessage(), source.getErrorCode(), source) : (source instanceof ResourceAllocationException ? new ResourceAllocationRuntimeException(source.getMessage(), source.getErrorCode(), source) : (source instanceof TransactionInProgressException ? new TransactionInProgressRuntimeException(source.getMessage(), source.getErrorCode(), source) : (source instanceof TransactionRolledBackException ? new TransactionRolledBackRuntimeException(source.getMessage(), source.getErrorCode(), source) : new JMSRuntimeException(source.getMessage(), source.getErrorCode(), source))))))))));
        return result;
    }
}

