/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.NoOpAsyncResult;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.WrappedAsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpAbstractResource;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResource;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpSubscriptionTracker;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.provider.amqp.builders.AmqpResourceBuilder;
import org.apache.qpid.jms.provider.exceptions.ProviderExceptionSupport;
import org.apache.qpid.jms.provider.exceptions.ProviderInvalidDestinationException;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpConnectionSession
extends AmqpSession {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpConnectionSession.class);
    private final Map<String, AsyncResult> pendingUnsubs = new HashMap<String, AsyncResult>();

    public AmqpConnectionSession(AmqpConnection connection, JmsSessionInfo info, Session session) {
        super(connection, info, session);
    }

    public void unsubscribe(String subscriptionName, boolean hasClientID, AsyncResult request) {
        AmqpSubscriptionTracker subTracker = this.getConnection().getSubTracker();
        String linkName = subTracker.getFirstDurableSubscriptionLinkName(subscriptionName, hasClientID);
        DurableSubscriptionReattachBuilder builder = new DurableSubscriptionReattachBuilder(this, (JmsSessionInfo)this.getResourceInfo(), linkName);
        DurableSubscriptionReattachRequest subscribeRequest = new DurableSubscriptionReattachRequest(subscriptionName, builder, request);
        this.pendingUnsubs.put(subscriptionName, subscribeRequest);
        LOG.debug("Attempting remove of subscription: {}", (Object)subscriptionName);
        builder.buildResource(subscribeRequest);
    }

    @Override
    public void addChildResource(AmqpResource resource) {
        if (resource instanceof AmqpConsumer) {
            AmqpConsumer consumer = (AmqpConsumer)resource;
            consumer.getConsumerId().getParentId().setProviderHint(this);
        }
        super.addChildResource(resource);
    }

    @Override
    public void handleResourceClosure(AmqpProvider provider, ProviderException cause) {
        ArrayList<AsyncResult> pending = new ArrayList<AsyncResult>(this.pendingUnsubs.values());
        for (AsyncResult unsubscribeRequest : pending) {
            unsubscribeRequest.onFailure(cause);
        }
        super.handleResourceClosure(provider, cause);
    }

    private final class DurableSubscriptionReattachRequest
    extends WrappedAsyncResult {
        private final String subscriptionName;
        private final DurableSubscriptionReattachBuilder subscriberBuilder;

        public DurableSubscriptionReattachRequest(String subscriptionName, DurableSubscriptionReattachBuilder subscriberBuilder, AsyncResult originalRequest) {
            super(originalRequest);
            this.subscriptionName = subscriptionName;
            this.subscriberBuilder = subscriberBuilder;
        }

        @Override
        public void onSuccess() {
            DurableSubscriptionReattach subscriber = (DurableSubscriptionReattach)this.subscriberBuilder.getResource();
            LOG.trace("Reattached to subscription '{}' using link name '{}'", (Object)this.subscriptionName, (Object)subscriber.getLinkName());
            AmqpConnectionSession.this.pendingUnsubs.remove(this.subscriptionName);
            if (((Receiver)subscriber.getEndpoint()).getRemoteSource() != null) {
                subscriber.close(this.getWrappedRequest());
            } else {
                subscriber.close(NoOpAsyncResult.INSTANCE);
                this.getWrappedRequest().onFailure(new ProviderInvalidDestinationException("Cannot remove a subscription that does not exist"));
            }
        }

        @Override
        public void onFailure(ProviderException cause) {
            DurableSubscriptionReattach subscriber = (DurableSubscriptionReattach)this.subscriberBuilder.getResource();
            LOG.trace("Failed to reattach to subscription '{}' using link name '{}'", (Object)this.subscriptionName, (Object)subscriber.getLinkName());
            AmqpConnectionSession.this.pendingUnsubs.remove(this.subscriptionName);
            subscriber.closeResource(AmqpConnectionSession.this.getProvider(), ProviderExceptionSupport.createNonFatalOrPassthrough(cause), false);
            super.onFailure(cause);
        }
    }

    private final class DurableSubscriptionReattachBuilder
    extends AmqpResourceBuilder<DurableSubscriptionReattach, AmqpSession, JmsSessionInfo, Receiver> {
        private final String linkName;
        private final boolean hasClientID;

        public DurableSubscriptionReattachBuilder(AmqpSession parent, JmsSessionInfo resourceInfo, String linkName) {
            super(parent, resourceInfo);
            this.hasClientID = ((JmsConnectionInfo)parent.getConnection().getResourceInfo()).isExplicitClientID();
            this.linkName = linkName;
        }

        @Override
        protected Receiver createEndpoint(JmsSessionInfo resourceInfo) {
            Receiver receiver = ((Session)((AmqpSession)this.getParent()).getEndpoint()).receiver(this.linkName);
            receiver.setTarget(new Target());
            receiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
            receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            if (!this.hasClientID) {
                receiver.setDesiredCapabilities(new Symbol[]{AmqpSupport.SHARED, AmqpSupport.GLOBAL});
            }
            return receiver;
        }

        @Override
        protected DurableSubscriptionReattach createResource(AmqpSession parent, JmsSessionInfo resourceInfo, Receiver endpoint) {
            return new DurableSubscriptionReattach(resourceInfo, endpoint, (AmqpResourceParent)AmqpConnectionSession.this.getProvider());
        }

        @Override
        protected boolean isClosePending() {
            return ((Receiver)this.endpoint).getRemoteSource() == null;
        }
    }

    private static final class DurableSubscriptionReattach
    extends AmqpAbstractResource<JmsSessionInfo, Receiver> {
        public DurableSubscriptionReattach(JmsSessionInfo resource, Receiver receiver, AmqpResourceParent parent) {
            super(resource, receiver, parent);
        }

        @Override
        public void processRemoteClose(AmqpProvider provider) throws ProviderException {
            if (((Receiver)this.getEndpoint()).getRemoteCondition().getCondition() != null) {
                this.closeResource(provider, AmqpSupport.convertToNonFatalException(provider, this.getEndpoint(), ((Receiver)this.getEndpoint()).getRemoteCondition()), true);
            } else {
                this.closeResource(provider, null, true);
            }
        }

        public String getLinkName() {
            return ((Receiver)this.getEndpoint()).getName();
        }
    }
}

