/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.nio.BufferOverflowException;
import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.meta.JmsTransactionId;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.amqp.AmqpAbstractResource;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.provider.amqp.AmqpTransactionContext;
import org.apache.qpid.jms.provider.amqp.AmqpTransferTagGenerator;
import org.apache.qpid.jms.provider.exceptions.ProviderExceptionSupport;
import org.apache.qpid.jms.provider.exceptions.ProviderIllegalStateException;
import org.apache.qpid.jms.provider.exceptions.ProviderOperationTimedOutException;
import org.apache.qpid.jms.provider.exceptions.ProviderTransactionInDoubtException;
import org.apache.qpid.jms.provider.exceptions.ProviderTransactionRolledBackException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transaction.Declare;
import org.apache.qpid.proton.amqp.transaction.Declared;
import org.apache.qpid.proton.amqp.transaction.Discharge;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTransactionCoordinator
extends AmqpAbstractResource<JmsSessionInfo, Sender> {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpTransactionCoordinator.class);
    private static final Boolean ROLLBACK_MARKER = Boolean.FALSE;
    private static final Boolean COMMIT_MARKER = Boolean.TRUE;
    private final byte[] OUTBOUND_BUFFER = new byte[64];
    private final AmqpTransferTagGenerator tagGenerator = new AmqpTransferTagGenerator();

    public AmqpTransactionCoordinator(JmsSessionInfo resourceInfo, Sender endpoint, AmqpResourceParent parent) {
        super(resourceInfo, endpoint, parent);
    }

    @Override
    public void processDeliveryUpdates(AmqpProvider provider, Delivery delivery) throws ProviderException {
        try {
            if (delivery != null && delivery.remotelySettled()) {
                DeliveryState state = delivery.getRemoteState();
                if (delivery.getContext() == null || !(delivery.getContext() instanceof OperationContext)) {
                    return;
                }
                OperationContext context = (OperationContext)delivery.getContext();
                AsyncResult pendingRequest = context.getRequest();
                JmsTransactionId txId = context.getTransactionId();
                if (state instanceof Declared) {
                    LOG.debug("New TX started: {}", (Object)txId);
                    Declared declared = (Declared)state;
                    txId.setProviderHint(declared.getTxnId());
                    pendingRequest.onSuccess();
                } else if (state instanceof Rejected) {
                    LOG.debug("Last TX request failed: {}", (Object)txId);
                    Rejected rejected = (Rejected)state;
                    ProviderException cause = AmqpSupport.convertToNonFatalException(this.getParent().getProvider(), this.getEndpoint(), rejected.getError());
                    cause = COMMIT_MARKER.equals(txId.getProviderContext()) && !(cause instanceof ProviderTransactionRolledBackException) ? new ProviderTransactionRolledBackException(cause.getMessage(), cause) : new ProviderTransactionInDoubtException(cause.getMessage(), cause);
                    txId.setProviderHint(null);
                    pendingRequest.onFailure(cause);
                } else {
                    LOG.debug("Last TX request succeeded: {}", (Object)txId);
                    pendingRequest.onSuccess();
                }
                delivery.settle();
                pendingRequest = null;
                if (context.getTimeout() != null) {
                    context.getTimeout().cancel(false);
                }
            }
            super.processDeliveryUpdates(provider, delivery);
        }
        catch (Throwable e) {
            throw ProviderExceptionSupport.createNonFatalOrPassthrough(e);
        }
    }

    public void declare(JmsTransactionId txId, AsyncResult request) throws ProviderException {
        if (this.isClosed()) {
            request.onFailure(new ProviderIllegalStateException("Cannot start new transaction: Coordinator remotely closed"));
            return;
        }
        if (txId.getProviderHint() != null) {
            throw new ProviderIllegalStateException("Declar called while a TX is still Active.");
        }
        Message message = Message.Factory.create();
        Declare declare = new Declare();
        message.setBody(new AmqpValue(declare));
        ScheduledFuture<?> timeout = this.scheduleTimeoutIfNeeded("Timed out waiting for declare of TX.", request);
        OperationContext context = new OperationContext(txId, request, timeout);
        Delivery delivery = ((Sender)this.getEndpoint()).delivery(this.tagGenerator.getNextTag());
        delivery.setContext(context);
        this.sendTxCommand(message);
    }

    public void discharge(JmsTransactionId txId, AmqpTransactionContext.DischargeCompletion request) throws ProviderException {
        if (this.isClosed()) {
            ProviderException failureCause = null;
            failureCause = request.isCommit() ? new ProviderTransactionRolledBackException("Transaction inbout: Coordinator remotely closed") : new ProviderIllegalStateException("Rollback cannot complete: Coordinator remotely closed");
            request.onFailure(failureCause);
            return;
        }
        if (txId.getProviderHint() == null) {
            throw new ProviderIllegalStateException("Discharge called with no active Transaction.");
        }
        txId.setProviderContext(request.isCommit() ? COMMIT_MARKER : ROLLBACK_MARKER);
        Message message = Message.Factory.create();
        Discharge discharge = new Discharge();
        discharge.setFail(!request.isCommit());
        discharge.setTxnId((Binary)txId.getProviderHint());
        message.setBody(new AmqpValue(discharge));
        ScheduledFuture<?> timeout = this.scheduleTimeoutIfNeeded("Timed out waiting for discharge of TX.", request);
        OperationContext context = new OperationContext(txId, request, timeout);
        Delivery delivery = ((Sender)this.getEndpoint()).delivery(this.tagGenerator.getNextTag());
        delivery.setContext(context);
        this.sendTxCommand(message);
    }

    @Override
    public void closeResource(AmqpProvider provider, ProviderException cause, boolean localClose) {
        Delivery pending = ((Sender)this.getEndpoint()).head();
        while (pending != null) {
            Delivery nextPending = pending.next();
            if (pending.getContext() != null && pending.getContext() instanceof OperationContext) {
                OperationContext context = (OperationContext)pending.getContext();
                context.request.onFailure(cause);
            }
            pending = nextPending;
        }
        if (this.getParent() != null) {
            this.getParent().removeChildResource(this);
        }
        if (this.getEndpoint() != null) {
            ((Sender)this.getEndpoint()).close();
            ((Sender)this.getEndpoint()).free();
        }
        LOG.debug("Transaction Coordinator link {} was remotely closed", this.getResourceInfo());
    }

    private ScheduledFuture<?> scheduleTimeoutIfNeeded(String cause, AsyncResult pendingRequest) {
        AmqpProvider provider = this.getParent().getProvider();
        if (provider.getRequestTimeout() != -1L) {
            return provider.scheduleRequestTimeout(pendingRequest, provider.getRequestTimeout(), new ProviderOperationTimedOutException(cause));
        }
        return null;
    }

    private void sendTxCommand(Message message) throws ProviderException {
        int encodedSize = 0;
        byte[] buffer = this.OUTBOUND_BUFFER;
        while (true) {
            try {
                encodedSize = message.encode(buffer, 0, buffer.length);
            }
            catch (BufferOverflowException e) {
                buffer = new byte[buffer.length * 2];
                continue;
            }
            break;
        }
        Sender sender = (Sender)this.getEndpoint();
        sender.send(buffer, 0, encodedSize);
        sender.advance();
    }

    private class OperationContext {
        private final AsyncResult request;
        private final ScheduledFuture<?> timeout;
        private final JmsTransactionId transactionId;

        public OperationContext(JmsTransactionId transactionId, AsyncResult request, ScheduledFuture<?> timeout) {
            this.transactionId = transactionId;
            this.request = request;
            this.timeout = timeout;
        }

        public JmsTransactionId getTransactionId() {
            return this.transactionId;
        }

        public AsyncResult getRequest() {
            return this.request;
        }

        public ScheduledFuture<?> getTimeout() {
            return this.timeout;
        }
    }
}

