/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.ArrayDeque;
import java.util.Deque;

public final class AmqpTransferTagGenerator {
    public static final int DEFAULT_TAG_POOL_SIZE = 1024;
    private final Deque<byte[]> tagPool;
    private long nextTagId;
    private int maxPoolSize = 1024;

    public AmqpTransferTagGenerator() {
        this(true);
    }

    public AmqpTransferTagGenerator(boolean pool) {
        this.tagPool = pool ? new ArrayDeque<byte[]>() : null;
    }

    public byte[] getNextTag() {
        byte[] tagBytes = null;
        if (this.tagPool != null) {
            tagBytes = this.tagPool.pollFirst();
        }
        if (tagBytes == null) {
            long tag = this.nextTagId++;
            int size = this.encodingSize(tag);
            tagBytes = new byte[size];
            for (int i2 = 0; i2 < size; ++i2) {
                tagBytes[size - 1 - i2] = (byte)(tag >>> i2 * 8);
            }
        }
        return tagBytes;
    }

    public void returnTag(byte[] data) {
        if (this.tagPool != null && this.tagPool.size() < this.maxPoolSize) {
            this.tagPool.offerLast(data);
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public boolean isPooling() {
        return this.tagPool != null;
    }

    private int encodingSize(long value) {
        int size;
        if (value < 0L) {
            return 8;
        }
        for (size = 1; size < 8 && value >= 1L << size * 8; ++size) {
        }
        return size;
    }
}

