/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.builders;

import java.util.Arrays;
import java.util.List;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.amqp.AmqpAnonymousFallbackProducer;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpFixedProducer;
import org.apache.qpid.jms.provider.amqp.AmqpProducer;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.provider.amqp.builders.AmqpResourceBuilder;
import org.apache.qpid.jms.provider.amqp.message.AmqpDestinationHelper;
import org.apache.qpid.jms.provider.exceptions.ProviderInvalidDestinationException;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpProducerBuilder
extends AmqpResourceBuilder<AmqpProducer, AmqpSession, JmsProducerInfo, Sender> {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpProducerBuilder.class);
    private boolean validateDelayedDeliveryLinkCapability;

    public AmqpProducerBuilder(AmqpSession parent, JmsProducerInfo resourceInfo) {
        super(parent, resourceInfo);
    }

    @Override
    public void buildResource(AsyncResult request) {
        if (((JmsProducerInfo)this.getResourceInfo()).getDestination() == null && !((AmqpSession)this.getParent()).getConnection().getProperties().isAnonymousRelaySupported()) {
            LOG.debug("Creating an AmqpAnonymousFallbackProducer");
            new AmqpAnonymousFallbackProducer((AmqpSession)this.getParent(), (JmsProducerInfo)this.getResourceInfo());
            request.onSuccess();
        } else {
            LOG.debug("Creating AmqpFixedProducer for: {}", (Object)((JmsProducerInfo)this.getResourceInfo()).getDestination());
            super.buildResource(request);
        }
    }

    @Override
    protected Sender createEndpoint(JmsProducerInfo resourceInfo) {
        JmsDestination destination = resourceInfo.getDestination();
        AmqpConnection connection = ((AmqpSession)this.getParent()).getConnection();
        String targetAddress = AmqpDestinationHelper.getDestinationAddress(destination, connection);
        Symbol[] outcomes = new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL, Released.DESCRIPTOR_SYMBOL, Modified.DESCRIPTOR_SYMBOL};
        String sourceAddress = resourceInfo.getId().toString();
        Source source = new Source();
        source.setAddress(sourceAddress);
        source.setOutcomes(outcomes);
        Target target = new Target();
        target.setAddress(targetAddress);
        Symbol typeCapability = AmqpDestinationHelper.toTypeCapability(destination);
        if (typeCapability != null) {
            target.setCapabilities(typeCapability);
        }
        String senderName = "qpid-jms:sender:" + sourceAddress + ":" + targetAddress;
        Sender sender = ((Session)((AmqpSession)this.getParent()).getEndpoint()).sender(senderName);
        sender.setSource(source);
        sender.setTarget(target);
        if (resourceInfo.isPresettle()) {
            sender.setSenderSettleMode(SenderSettleMode.SETTLED);
        } else {
            sender.setSenderSettleMode(SenderSettleMode.UNSETTLED);
        }
        sender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        if (!connection.getProperties().isDelayedDeliverySupported()) {
            this.validateDelayedDeliveryLinkCapability = true;
            sender.setDesiredCapabilities(new Symbol[]{AmqpSupport.DELAYED_DELIVERY});
        }
        return sender;
    }

    @Override
    protected AmqpProducer createResource(AmqpSession parent, JmsProducerInfo resourceInfo, Sender endpoint) {
        return new AmqpFixedProducer((AmqpSession)this.getParent(), (JmsProducerInfo)this.getResourceInfo(), endpoint);
    }

    @Override
    protected void afterOpened() {
        if (this.validateDelayedDeliveryLinkCapability) {
            List<Symbol> list;
            Symbol[] remoteOfferedCapabilities = ((Sender)this.endpoint).getRemoteOfferedCapabilities();
            boolean supported = false;
            if (remoteOfferedCapabilities != null && (list = Arrays.asList(remoteOfferedCapabilities)).contains(AmqpSupport.DELAYED_DELIVERY)) {
                supported = true;
            }
            ((AmqpProducer)this.getResource()).setDelayedDeliverySupported(supported);
        }
    }

    @Override
    protected boolean isClosePending() {
        return ((Sender)this.getEndpoint()).getRemoteTarget() == null;
    }

    @Override
    protected ProviderException getDefaultOpenAbortException() {
        org.apache.qpid.proton.amqp.transport.Target target = ((Sender)this.getEndpoint()).getRemoteTarget();
        if (target != null) {
            return super.getDefaultOpenAbortException();
        }
        return new ProviderInvalidDestinationException("Link creation was refused");
    }
}

