/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.amqp;

import jakarta.jms.ConnectionFactory;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.amqp.AMQPConfiguration;
import org.apache.camel.component.amqp.AMQPConnectionDetails;
import org.apache.camel.component.amqp.AMQPJmsBinding;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.qpid.jms.JmsConnectionFactory;

@Component(value="amqp")
public class AMQPComponent
extends JmsComponent {
    public AMQPComponent() {
    }

    public AMQPComponent(JmsConfiguration configuration) {
        super(configuration);
    }

    public AMQPComponent(CamelContext context) {
        super(context);
    }

    public AMQPComponent(ConnectionFactory connectionFactory) {
        this();
        this.getConfiguration().setConnectionFactory(connectionFactory);
    }

    public static AMQPComponent amqpComponent(String uri) {
        JmsConnectionFactory connectionFactory = new JmsConnectionFactory(uri);
        connectionFactory.setTopicPrefix("topic://");
        return new AMQPComponent(connectionFactory);
    }

    public static AMQPComponent amqpComponent(String uri, String username, String password) {
        JmsConnectionFactory connectionFactory = new JmsConnectionFactory(username, password, uri);
        connectionFactory.setTopicPrefix("topic://");
        return new AMQPComponent(connectionFactory);
    }

    @Override
    protected void doInit() throws Exception {
        Set<AMQPConnectionDetails> connectionDetails = this.getCamelContext().getRegistry().findByType(AMQPConnectionDetails.class);
        if (connectionDetails.size() == 1) {
            AMQPConnectionDetails details = connectionDetails.iterator().next();
            JmsConnectionFactory connectionFactory = new JmsConnectionFactory(details.username(), details.password(), details.uri());
            if (details.setTopicPrefix()) {
                connectionFactory.setTopicPrefix("topic://");
            }
            this.getConfiguration().setConnectionFactory(connectionFactory);
        }
        super.doInit();
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        JmsEndpoint endpoint = (JmsEndpoint)super.createEndpoint(uri, remaining, parameters);
        endpoint.setBinding(new AMQPJmsBinding(endpoint));
        return endpoint;
    }

    @Override
    protected JmsConfiguration createConfiguration() {
        return new AMQPConfiguration();
    }

    @Metadata(displayName="Include AMQP Annotations")
    public void setIncludeAmqpAnnotations(boolean includeAmqpAnnotations) {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof AMQPConfiguration) {
            AMQPConfiguration amqpConfiguration = (AMQPConfiguration)jmsConfiguration;
            amqpConfiguration.setIncludeAmqpAnnotations(includeAmqpAnnotations);
        }
    }

    public boolean isIncludeAmqpAnnotations() {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof AMQPConfiguration) {
            AMQPConfiguration amqpConfiguration = (AMQPConfiguration)jmsConfiguration;
            return amqpConfiguration.isIncludeAmqpAnnotations();
        }
        return false;
    }

    @Override
    protected void setProperties(Endpoint bean2, Map<String, Object> parameters) throws Exception {
        Object includeAmqpAnnotations = parameters.remove("includeAmqpAnnotations");
        if (includeAmqpAnnotations != null) {
            ((AMQPConfiguration)((JmsEndpoint)bean2).getConfiguration()).setIncludeAmqpAnnotations(PropertyConfigurerSupport.property(this.getCamelContext(), Boolean.TYPE, includeAmqpAnnotations));
        }
        super.setProperties(bean2, parameters);
    }
}

