/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.ExceptionListener;
import jakarta.jms.Message;
import jakarta.jms.Session;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Category;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultJmsMessageListenerContainer;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsConstants;
import org.apache.camel.component.jms.JmsConsumer;
import org.apache.camel.component.jms.JmsHeaderFilterStrategy;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.component.jms.JmsPollingConsumer;
import org.apache.camel.component.jms.JmsProducer;
import org.apache.camel.component.jms.JmsServiceLocationHelper;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.component.jms.TemporaryQueueResolver;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.SynchronousDelegateProducer;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.UnwrapHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.SimpleMessageListenerContainer;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

@ManagedResource(description="Managed JMS Endpoint")
@UriEndpoint(firstVersion="1.0.0", scheme="jms", title="JMS", syntax="jms:destinationType:destinationName", category={Category.MESSAGING}, headersClass=JmsConstants.class)
@Metadata(excludeProperties="bridgeErrorHandler")
public class JmsEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
HeaderFilterStrategyAware,
MultipleConsumersSupport,
EndpointServiceLocation {
    private static final Logger LOG = LoggerFactory.getLogger(JmsEndpoint.class);
    private String serviceUrl;
    private String serviceProtocol;
    private Map<String, String> serviceMetadata;
    private final AtomicInteger runningMessageListeners = new AtomicInteger();
    private boolean pubSubDomain;
    private JmsBinding binding;
    @UriPath(defaultValue="queue", enums="queue,topic,temp-queue,temp-topic", description="The kind of destination to use")
    private String destinationType;
    @UriPath(description="Name of the queue or topic to use as destination")
    @Metadata(required=true)
    private String destinationName;
    @UriParam(label="advanced", description="To use a custom HeaderFilterStrategy to filter header to and from Camel message.")
    private HeaderFilterStrategy headerFilterStrategy;
    @UriParam
    private JmsConfiguration configuration;

    public JmsEndpoint() {
    }

    public JmsEndpoint(String uri, JmsComponent component, String destinationName, boolean pubSubDomain, JmsConfiguration configuration) {
        super(UnsafeUriCharactersEncoder.encode(uri), component);
        this.configuration = configuration;
        this.destinationName = destinationName;
        this.pubSubDomain = pubSubDomain;
        this.destinationType = pubSubDomain ? "topic" : "queue";
    }

    public JmsEndpoint(String endpointUri, JmsBinding binding, JmsConfiguration configuration, String destinationName, boolean pubSubDomain) {
        super(UnsafeUriCharactersEncoder.encode(endpointUri), null);
        this.binding = binding;
        this.configuration = configuration;
        this.destinationName = destinationName;
        this.pubSubDomain = pubSubDomain;
        this.destinationType = pubSubDomain ? "topic" : "queue";
    }

    public JmsEndpoint(String endpointUri, String destinationName, boolean pubSubDomain) {
        this(UnsafeUriCharactersEncoder.encode(endpointUri), null, new JmsConfiguration(), destinationName, pubSubDomain);
        this.binding = new JmsBinding(this);
        this.destinationType = pubSubDomain ? "topic" : "queue";
    }

    public JmsEndpoint(String endpointUri, String destinationName) {
        this(UnsafeUriCharactersEncoder.encode(endpointUri), destinationName, true);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.getComponent().isServiceLocationEnabled()) {
            ConnectionFactory actual;
            BeanIntrospection bi = PluginHelper.getBeanIntrospection(this.getCamelContext());
            ConnectionFactory cf = this.getConnectionFactory();
            if (cf != null && cf.getClass().getName().endsWith("ClientProxy") && (actual = UnwrapHelper.unwrapClientProxy(cf)) != null) {
                cf = actual;
            }
            this.serviceUrl = JmsServiceLocationHelper.getBrokerURLFromConnectionFactory(bi, cf);
            this.serviceProtocol = this.getComponent().getDefaultName();
            this.serviceMetadata = new HashMap<String, String>();
            String user = JmsServiceLocationHelper.getUsernameFromConnectionFactory(bi, cf);
            if (user != null) {
                this.serviceMetadata.put("username", user);
                if (this.getConfiguration().getClientId() != null) {
                    this.serviceMetadata.put("clientId", this.getConfiguration().getClientId());
                }
            }
        }
    }

    @Override
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Override
    public String getServiceProtocol() {
        return this.serviceProtocol;
    }

    @Override
    public Map<String, String> getServiceMetadata() {
        if (this.serviceMetadata != null && !this.serviceMetadata.isEmpty()) {
            return this.serviceMetadata;
        }
        return null;
    }

    @Override
    public Producer createProducer() throws Exception {
        JmsProducer answer = new JmsProducer(this);
        if (this.getConfiguration().isSynchronous()) {
            return new SynchronousDelegateProducer(answer);
        }
        return answer;
    }

    @Override
    public JmsConsumer createConsumer(Processor processor) throws Exception {
        AbstractMessageListenerContainer listenerContainer = this.createMessageListenerContainer();
        return this.createConsumer(processor, listenerContainer);
    }

    public AbstractMessageListenerContainer createMessageListenerContainer() {
        return this.configuration.createMessageListenerContainer(this);
    }

    public AbstractMessageListenerContainer createReplyToMessageListenerContainer() {
        return this.configuration.chooseMessageListenerContainerImplementation(this, this.configuration.getReplyToConsumerType());
    }

    public void configureListenerContainer(AbstractMessageListenerContainer listenerContainer, JmsConsumer consumer) {
        if (this.destinationName != null) {
            Object target = this.destinationName;
            if (this.getConfiguration().getArtemisConsumerPriority() != 0) {
                target = (String)target + "?consumer-priority=" + this.getConfiguration().getArtemisConsumerPriority();
            }
            listenerContainer.setDestinationName((String)target);
            LOG.debug("Using destinationName: {} on listenerContainer: {}", (Object)this.destinationName, (Object)listenerContainer);
        } else {
            DestinationResolver resolver = this.getDestinationResolver();
            if (resolver == null) {
                throw new IllegalArgumentException("Neither destination, destinationName or destinationResolver are specified on this endpoint!");
            }
            listenerContainer.setDestinationResolver(resolver);
            LOG.debug("Using destinationResolver: {} on listenerContainer: {}", (Object)resolver, (Object)listenerContainer);
        }
        listenerContainer.setPubSubDomain(this.pubSubDomain);
        String consumerName = this.getThreadName();
        if (this.configuration.getTaskExecutor() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using custom TaskExecutor: {} on listener container: {}", (Object)this.configuration.getTaskExecutor(), (Object)listenerContainer);
            }
            this.setContainerTaskExecutor(listenerContainer, this.configuration.getTaskExecutor());
            TaskExecutor taskExecutor = this.configuration.getTaskExecutor();
            if (taskExecutor instanceof ExecutorService) {
                ExecutorService executorService = (ExecutorService)((Object)taskExecutor);
                consumer.setListenerContainerExecutorService(executorService, false);
            }
        } else if (!(listenerContainer instanceof DefaultJmsMessageListenerContainer) || this.configuration.getDefaultTaskExecutorType() == null) {
            ExecutorService executor = this.getCamelContext().getExecutorServiceManager().newCachedThreadPool(consumer, consumerName);
            this.setContainerTaskExecutor(listenerContainer, executor);
            consumer.setListenerContainerExecutorService(executor, true);
        } else {
            LOG.debug("Deferring creation of TaskExecutor for listener container: {} as per policy: {}", (Object)listenerContainer, (Object)this.getDefaultTaskExecutorType());
        }
        if (this.configuration.getTransactionName() == null && listenerContainer instanceof DefaultMessageListenerContainer) {
            DefaultMessageListenerContainer defaultMessageListenerContainer = (DefaultMessageListenerContainer)listenerContainer;
            defaultMessageListenerContainer.setTransactionName(consumerName);
        }
        if (this.configuration.getDurableSubscriptionName() != null) {
            listenerContainer.setDurableSubscriptionName(this.configuration.getDurableSubscriptionName());
        } else if (this.configuration.isSubscriptionDurable()) {
            listenerContainer.setSubscriptionDurable(true);
        }
        if (this.configuration.getSubscriptionName() != null) {
            listenerContainer.setSubscriptionName(this.configuration.getSubscriptionName());
        }
        listenerContainer.setSubscriptionShared(this.configuration.isSubscriptionShared());
    }

    private void setContainerTaskExecutor(AbstractMessageListenerContainer listenerContainer, Executor executor) {
        if (listenerContainer instanceof SimpleMessageListenerContainer) {
            SimpleMessageListenerContainer container = (SimpleMessageListenerContainer)listenerContainer;
            container.setTaskExecutor(executor);
        } else if (listenerContainer instanceof DefaultMessageListenerContainer) {
            DefaultMessageListenerContainer defaultMessageListenerContainer = (DefaultMessageListenerContainer)listenerContainer;
            defaultMessageListenerContainer.setTaskExecutor(executor);
        }
    }

    public String getEndpointConfiguredDestinationName() {
        String remainder = StringHelper.after(this.getEndpointKey(), "//");
        if (remainder != null && remainder.contains("?")) {
            remainder = StringHelper.before(remainder, "?");
        }
        return JmsMessageHelper.normalizeDestinationName(remainder);
    }

    public JmsConsumer createConsumer(Processor processor, AbstractMessageListenerContainer listenerContainer) throws Exception {
        JmsConsumer consumer = new JmsConsumer(this, processor, listenerContainer);
        this.configureListenerContainer(listenerContainer, consumer);
        this.configureConsumer(consumer);
        if (this.isBridgeErrorHandler()) {
            throw new IllegalArgumentException("BridgeErrorHandler is not support on JMS endpoint");
        }
        String replyTo = consumer.getEndpoint().getReplyTo();
        if (replyTo != null && consumer.getEndpoint().getDestinationName().equals(replyTo)) {
            throw new IllegalArgumentException("Invalid Endpoint configuration: " + String.valueOf(consumer.getEndpoint()) + ". ReplyTo=" + replyTo + " cannot be the same as the destination name on the JmsConsumer as that would lead to the consumer sending reply messages to itself in an endless loop.");
        }
        return consumer;
    }

    @Override
    public PollingConsumer createPollingConsumer() throws Exception {
        JmsPollingConsumer answer = new JmsPollingConsumer(this, this.createInOnlyTemplate());
        this.configurePollingConsumer(answer);
        return answer;
    }

    @Override
    public Exchange createExchange(ExchangePattern pattern) {
        Exchange exchange = super.createExchange(pattern);
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        return exchange;
    }

    public Exchange createExchange(Message message, Session session) {
        Exchange exchange = this.createExchange(this.getExchangePattern());
        exchange.setIn(new JmsMessage(exchange, message, session, this.getBinding()));
        return exchange;
    }

    public JmsOperations createInOnlyTemplate() {
        return this.configuration.createInOnlyTemplate(this, this.pubSubDomain, this.destinationName);
    }

    public JmsOperations createInOutTemplate() {
        return this.configuration.createInOutTemplate(this, this.pubSubDomain, this.destinationName, this.configuration.getRequestTimeout());
    }

    @Override
    public boolean isMultipleConsumersSupported() {
        return true;
    }

    public String getThreadName() {
        return "JmsConsumer[" + this.getEndpointConfiguredDestinationName() + "]";
    }

    @Override
    public JmsComponent getComponent() {
        return (JmsComponent)super.getComponent();
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new JmsHeaderFilterStrategy(this.isIncludeAllJMSXProperties());
        }
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = this.createBinding();
        }
        return this.binding;
    }

    protected JmsBinding createBinding() {
        return new JmsBinding(this);
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public JmsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JmsConfiguration configuration) {
        this.configuration = configuration;
    }

    @ManagedAttribute
    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    protected ExecutorService getAsyncStartStopExecutorService() {
        if (this.getComponent() == null) {
            throw new IllegalStateException("AsyncStartStopListener requires JmsComponent to be configured on this endpoint: " + String.valueOf(this));
        }
        return this.getComponent().getAsyncStartStopExecutorService();
    }

    public void onListenerContainerStarting() {
        this.runningMessageListeners.incrementAndGet();
    }

    public void onListenerContainerStopped() {
        this.runningMessageListeners.decrementAndGet();
    }

    protected boolean isRunning() {
        return this.isStarted();
    }

    @Override
    public void stop() {
        int running = this.runningMessageListeners.get();
        if (running <= 0) {
            super.stop();
        } else {
            LOG.trace("There are still {} running message listeners. Cannot stop endpoint {}", (Object)running, (Object)this);
        }
    }

    @Override
    public void shutdown() {
        int running = this.runningMessageListeners.get();
        if (running <= 0) {
            super.shutdown();
        } else {
            LOG.trace("There are still {} running message listeners. Cannot shutdown endpoint {}", (Object)running, (Object)this);
        }
    }

    @ManagedAttribute
    public int getAcknowledgementMode() {
        return this.getConfiguration().getAcknowledgementMode();
    }

    @ManagedAttribute
    public String getAcknowledgementModeName() {
        return this.getConfiguration().getAcknowledgementModeName();
    }

    @ManagedAttribute
    public int getCacheLevel() {
        return this.getConfiguration().getCacheLevel();
    }

    @ManagedAttribute
    public String getCacheLevelName() {
        return this.getConfiguration().getCacheLevelName();
    }

    @ManagedAttribute
    public String getReplyToCacheLevelName() {
        return this.getConfiguration().getReplyToCacheLevelName();
    }

    @ManagedAttribute
    public String getClientId() {
        return this.getConfiguration().getClientId();
    }

    @ManagedAttribute
    public int getConcurrentConsumers() {
        return this.getConfiguration().getConcurrentConsumers();
    }

    @ManagedAttribute
    public int getReplyToConcurrentConsumers() {
        return this.getConfiguration().getReplyToConcurrentConsumers();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.getConfiguration().getConnectionFactory();
    }

    public DestinationResolver getDestinationResolver() {
        return this.getConfiguration().getDestinationResolver();
    }

    public TemporaryQueueResolver getTemporaryQueueResolver() {
        return this.getConfiguration().getTemporaryQueueResolver();
    }

    @ManagedAttribute
    public String getDurableSubscriptionName() {
        return this.getConfiguration().getDurableSubscriptionName();
    }

    public ExceptionListener getExceptionListener() {
        return this.getConfiguration().getExceptionListener();
    }

    public ErrorHandler getErrorHandler() {
        return this.getConfiguration().getErrorHandler();
    }

    public LoggingLevel getErrorHandlerLoggingLevel() {
        return this.getConfiguration().getErrorHandlerLoggingLevel();
    }

    @ManagedAttribute
    public boolean isErrorHandlerLogStackTrace() {
        return this.getConfiguration().isErrorHandlerLogStackTrace();
    }

    @ManagedAttribute
    public void setErrorHandlerLogStackTrace(boolean errorHandlerLogStackTrace) {
        this.getConfiguration().setErrorHandlerLogStackTrace(errorHandlerLogStackTrace);
    }

    @ManagedAttribute
    public int getIdleTaskExecutionLimit() {
        return this.getConfiguration().getIdleTaskExecutionLimit();
    }

    @ManagedAttribute
    public int getIdleConsumerLimit() {
        return this.getConfiguration().getIdleConsumerLimit();
    }

    public JmsOperations getJmsOperations() {
        return this.getConfiguration().getJmsOperations();
    }

    public ConnectionFactory getListenerConnectionFactory() {
        return this.getConfiguration().getListenerConnectionFactory();
    }

    @ManagedAttribute
    public int getMaxConcurrentConsumers() {
        return this.getConfiguration().getMaxConcurrentConsumers();
    }

    @ManagedAttribute
    public int getReplyToMaxConcurrentConsumers() {
        return this.getConfiguration().getReplyToMaxConcurrentConsumers();
    }

    @ManagedAttribute
    public int getReplyToOnTimeoutMaxConcurrentConsumers() {
        return this.getConfiguration().getReplyToOnTimeoutMaxConcurrentConsumers();
    }

    @ManagedAttribute
    public int getMaxMessagesPerTask() {
        return this.getConfiguration().getMaxMessagesPerTask();
    }

    public MessageConverter getMessageConverter() {
        return this.getConfiguration().getMessageConverter();
    }

    @ManagedAttribute
    public int getPriority() {
        return this.getConfiguration().getPriority();
    }

    @ManagedAttribute
    public long getReceiveTimeout() {
        return this.getConfiguration().getReceiveTimeout();
    }

    @ManagedAttribute
    public long getRecoveryInterval() {
        return this.getConfiguration().getRecoveryInterval();
    }

    @ManagedAttribute
    public String getReplyTo() {
        return this.getConfiguration().getReplyTo();
    }

    @ManagedAttribute
    public String getReplyToOverride() {
        return this.getConfiguration().getReplyToOverride();
    }

    @ManagedAttribute
    public boolean isReplyToSameDestinationAllowed() {
        return this.getConfiguration().isReplyToSameDestinationAllowed();
    }

    @ManagedAttribute
    public String getReplyToDestinationSelectorName() {
        return this.getConfiguration().getReplyToDestinationSelectorName();
    }

    @ManagedAttribute
    public long getRequestTimeout() {
        return this.getConfiguration().getRequestTimeout();
    }

    @ManagedAttribute
    public long getRequestTimeoutCheckerInterval() {
        return this.getConfiguration().getRequestTimeoutCheckerInterval();
    }

    public TaskExecutor getTaskExecutor() {
        return this.getConfiguration().getTaskExecutor();
    }

    public ConnectionFactory getTemplateConnectionFactory() {
        return this.getConfiguration().getTemplateConnectionFactory();
    }

    @ManagedAttribute
    public long getTimeToLive() {
        return this.getConfiguration().getTimeToLive();
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.getConfiguration().getTransactionManager();
    }

    @ManagedAttribute
    public String getTransactionName() {
        return this.getConfiguration().getTransactionName();
    }

    @ManagedAttribute
    public int getTransactionTimeout() {
        return this.getConfiguration().getTransactionTimeout();
    }

    @ManagedAttribute
    public boolean isAcceptMessagesWhileStopping() {
        return this.getConfiguration().isAcceptMessagesWhileStopping();
    }

    @ManagedAttribute
    public boolean isAllowReplyManagerQuickStop() {
        return this.getConfiguration().isAllowReplyManagerQuickStop();
    }

    @ManagedAttribute
    public boolean isAlwaysCopyMessage() {
        return this.getConfiguration().isAlwaysCopyMessage();
    }

    @ManagedAttribute
    public boolean isAutoStartup() {
        return this.getConfiguration().isAutoStartup();
    }

    @ManagedAttribute
    public boolean isDeliveryPersistent() {
        return this.getConfiguration().isDeliveryPersistent();
    }

    @ManagedAttribute
    public Integer getDeliveryMode() {
        return this.getConfiguration().getDeliveryMode();
    }

    @ManagedAttribute
    public boolean isDisableReplyTo() {
        return this.getConfiguration().isDisableReplyTo();
    }

    @ManagedAttribute
    public String getEagerPoisonBody() {
        return this.getConfiguration().getEagerPoisonBody();
    }

    @ManagedAttribute
    public boolean isEagerLoadingOfProperties() {
        return this.getConfiguration().isEagerLoadingOfProperties();
    }

    @ManagedAttribute
    public boolean isExplicitQosEnabled() {
        return this.getConfiguration().isExplicitQosEnabled();
    }

    @ManagedAttribute
    public boolean isExposeListenerSession() {
        return this.getConfiguration().isExposeListenerSession();
    }

    @ManagedAttribute
    public boolean isMessageIdEnabled() {
        return this.getConfiguration().isMessageIdEnabled();
    }

    @ManagedAttribute
    public boolean isMessageTimestampEnabled() {
        return this.getConfiguration().isMessageTimestampEnabled();
    }

    @ManagedAttribute
    public boolean isPreserveMessageQos() {
        return this.getConfiguration().isPreserveMessageQos();
    }

    @ManagedAttribute
    public boolean isPubSubNoLocal() {
        return this.getConfiguration().isPubSubNoLocal();
    }

    @ManagedAttribute
    public boolean isReplyToDeliveryPersistent() {
        return this.getConfiguration().isReplyToDeliveryPersistent();
    }

    @ManagedAttribute
    public boolean isTransacted() {
        return this.getConfiguration().isTransacted();
    }

    @ManagedAttribute
    public boolean isTransactedInOut() {
        return this.getConfiguration().isTransactedInOut();
    }

    @ManagedAttribute
    public boolean isLazyCreateTransactionManager() {
        return this.getConfiguration().isLazyCreateTransactionManager();
    }

    @ManagedAttribute
    public boolean isUseMessageIDAsCorrelationID() {
        return this.getConfiguration().isUseMessageIDAsCorrelationID();
    }

    @ManagedAttribute
    public void setAcceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        this.getConfiguration().setAcceptMessagesWhileStopping(acceptMessagesWhileStopping);
    }

    @ManagedAttribute
    public void setAllowReplyManagerQuickStop(boolean allowReplyManagerQuickStop) {
        this.getConfiguration().setAllowReplyManagerQuickStop(allowReplyManagerQuickStop);
    }

    @ManagedAttribute
    public void setAcknowledgementMode(int consumerAcknowledgementMode) {
        this.getConfiguration().setAcknowledgementMode(consumerAcknowledgementMode);
    }

    @ManagedAttribute
    public void setAcknowledgementModeName(String consumerAcknowledgementMode) {
        this.getConfiguration().setAcknowledgementModeName(consumerAcknowledgementMode);
    }

    @ManagedAttribute
    public void setAlwaysCopyMessage(boolean alwaysCopyMessage) {
        this.getConfiguration().setAlwaysCopyMessage(alwaysCopyMessage);
    }

    @ManagedAttribute
    public void setAutoStartup(boolean autoStartup) {
        this.getConfiguration().setAutoStartup(autoStartup);
    }

    @ManagedAttribute
    public void setCacheLevel(int cacheLevel) {
        this.getConfiguration().setCacheLevel(cacheLevel);
    }

    @ManagedAttribute
    public void setCacheLevelName(String cacheName) {
        this.getConfiguration().setCacheLevelName(cacheName);
    }

    @ManagedAttribute
    public void setReplyToCacheLevelName(String cacheName) {
        this.getConfiguration().setReplyToCacheLevelName(cacheName);
    }

    @ManagedAttribute
    public void setClientId(String consumerClientId) {
        this.getConfiguration().setClientId(consumerClientId);
    }

    @ManagedAttribute
    public void setConcurrentConsumers(int concurrentConsumers) {
        this.getConfiguration().setConcurrentConsumers(concurrentConsumers);
    }

    @ManagedAttribute
    public void setReplyToConcurrentConsumers(int concurrentConsumers) {
        this.getConfiguration().setReplyToConcurrentConsumers(concurrentConsumers);
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.getConfiguration().setConnectionFactory(connectionFactory);
    }

    @ManagedAttribute
    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.getConfiguration().setDeliveryPersistent(deliveryPersistent);
    }

    @ManagedAttribute
    public void setDeliveryMode(Integer deliveryMode) {
        this.getConfiguration().setDeliveryMode(deliveryMode);
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.getConfiguration().setDestinationResolver(destinationResolver);
    }

    public void setDestinationResolver(TemporaryQueueResolver temporaryQueueResolver) {
        this.getConfiguration().setTemporaryQueueResolver(temporaryQueueResolver);
    }

    @ManagedAttribute
    public void setDisableReplyTo(boolean disableReplyTo) {
        this.getConfiguration().setDisableReplyTo(disableReplyTo);
    }

    @ManagedAttribute
    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.getConfiguration().setDurableSubscriptionName(durableSubscriptionName);
    }

    @ManagedAttribute
    public void setEagerPoisonBody(String eagerPoisonBody) {
        this.getConfiguration().setEagerPoisonBody(eagerPoisonBody);
    }

    @ManagedAttribute
    public void setEagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
        this.getConfiguration().setEagerLoadingOfProperties(eagerLoadingOfProperties);
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.getConfiguration().setExceptionListener(exceptionListener);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.getConfiguration().setErrorHandler(errorHandler);
    }

    @ManagedAttribute
    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.getConfiguration().setExplicitQosEnabled(explicitQosEnabled);
    }

    @ManagedAttribute
    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.getConfiguration().setExposeListenerSession(exposeListenerSession);
    }

    @ManagedAttribute
    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.getConfiguration().setIdleTaskExecutionLimit(idleTaskExecutionLimit);
    }

    @ManagedAttribute
    public void setIdleConsumerLimit(int idleConsumerLimit) {
        this.getConfiguration().setIdleConsumerLimit(idleConsumerLimit);
    }

    public void setJmsOperations(JmsOperations jmsOperations) {
        this.getConfiguration().setJmsOperations(jmsOperations);
    }

    public void setListenerConnectionFactory(ConnectionFactory listenerConnectionFactory) {
        this.getConfiguration().setListenerConnectionFactory(listenerConnectionFactory);
    }

    @ManagedAttribute
    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.getConfiguration().setMaxConcurrentConsumers(maxConcurrentConsumers);
    }

    @ManagedAttribute
    public void setReplyToMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.getConfiguration().setReplyToMaxConcurrentConsumers(maxConcurrentConsumers);
    }

    @ManagedAttribute
    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.getConfiguration().setMaxMessagesPerTask(maxMessagesPerTask);
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.getConfiguration().setMessageConverter(messageConverter);
    }

    @ManagedAttribute
    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.getConfiguration().setMessageIdEnabled(messageIdEnabled);
    }

    @ManagedAttribute
    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.getConfiguration().setMessageTimestampEnabled(messageTimestampEnabled);
    }

    @ManagedAttribute
    public void setPreserveMessageQos(boolean preserveMessageQos) {
        this.getConfiguration().setPreserveMessageQos(preserveMessageQos);
    }

    @ManagedAttribute
    public void setPriority(int priority) {
        this.getConfiguration().setPriority(priority);
    }

    @ManagedAttribute
    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.getConfiguration().setPubSubNoLocal(pubSubNoLocal);
    }

    @ManagedAttribute
    public void setReceiveTimeout(long receiveTimeout) {
        this.getConfiguration().setReceiveTimeout(receiveTimeout);
    }

    @ManagedAttribute
    public void setRecoveryInterval(long recoveryInterval) {
        this.getConfiguration().setRecoveryInterval(recoveryInterval);
    }

    @ManagedAttribute
    public void setReplyTo(String replyToDestination) {
        this.getConfiguration().setReplyTo(replyToDestination);
    }

    @ManagedAttribute
    public void setReplyToOverride(String replyToDestination) {
        this.getConfiguration().setReplyToOverride(replyToDestination);
    }

    @ManagedAttribute
    public void setReplyToSameDestinationAllowed(boolean replyToSameDestinationAllowed) {
        this.getConfiguration().setReplyToSameDestinationAllowed(replyToSameDestinationAllowed);
    }

    @ManagedAttribute
    public void setReplyToDeliveryPersistent(boolean replyToDeliveryPersistent) {
        this.getConfiguration().setReplyToDeliveryPersistent(replyToDeliveryPersistent);
    }

    @ManagedAttribute
    public void setReplyToDestinationSelectorName(String replyToDestinationSelectorName) {
        this.getConfiguration().setReplyToDestinationSelectorName(replyToDestinationSelectorName);
    }

    @ManagedAttribute
    public void setRequestTimeout(long requestTimeout) {
        this.getConfiguration().setRequestTimeout(requestTimeout);
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.getConfiguration().setTaskExecutor(taskExecutor);
    }

    public void setTemplateConnectionFactory(ConnectionFactory templateConnectionFactory) {
        this.getConfiguration().setTemplateConnectionFactory(templateConnectionFactory);
    }

    @ManagedAttribute
    public void setTimeToLive(long timeToLive) {
        this.getConfiguration().setTimeToLive(timeToLive);
    }

    @ManagedAttribute
    public void setTransacted(boolean transacted) {
        this.getConfiguration().setTransacted(transacted);
    }

    @ManagedAttribute
    public void setLazyCreateTransactionManager(boolean lazyCreating) {
        this.getConfiguration().setLazyCreateTransactionManager(lazyCreating);
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.getConfiguration().setTransactionManager(transactionManager);
    }

    @ManagedAttribute
    public void setTransactionName(String transactionName) {
        this.getConfiguration().setTransactionName(transactionName);
    }

    @ManagedAttribute
    public void setTransactionTimeout(int transactionTimeout) {
        this.getConfiguration().setTransactionTimeout(transactionTimeout);
    }

    @ManagedAttribute
    public void setUseMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
        this.getConfiguration().setUseMessageIDAsCorrelationID(useMessageIDAsCorrelationID);
    }

    public JmsMessageType getJmsMessageType() {
        return this.getConfiguration().getJmsMessageType();
    }

    public void setJmsMessageType(JmsMessageType jmsMessageType) {
        this.getConfiguration().setJmsMessageType(jmsMessageType);
    }

    public JmsKeyFormatStrategy getJmsKeyFormatStrategy() {
        return this.getConfiguration().getJmsKeyFormatStrategy();
    }

    public void setJmsKeyFormatStrategy(JmsKeyFormatStrategy jmsHeaderStrategy) {
        this.getConfiguration().setJmsKeyFormatStrategy(jmsHeaderStrategy);
    }

    public MessageCreatedStrategy getMessageCreatedStrategy() {
        return this.getConfiguration().getMessageCreatedStrategy();
    }

    public void setMessageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
        this.getConfiguration().setMessageCreatedStrategy(messageCreatedStrategy);
    }

    @ManagedAttribute
    public boolean isTransferExchange() {
        return this.getConfiguration().isTransferExchange();
    }

    @ManagedAttribute
    public void setTransferExchange(boolean transferExchange) {
        this.getConfiguration().setTransferExchange(transferExchange);
    }

    @ManagedAttribute
    public boolean isAllowSerializedHeaders() {
        return this.getConfiguration().isAllowSerializedHeaders();
    }

    @ManagedAttribute
    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.getConfiguration().setAllowSerializedHeaders(allowSerializedHeaders);
    }

    @ManagedAttribute
    public boolean isTransferException() {
        return this.getConfiguration().isTransferException();
    }

    @ManagedAttribute
    public void setTransferException(boolean transferException) {
        this.getConfiguration().setTransferException(transferException);
    }

    @ManagedAttribute
    public boolean isTestConnectionOnStartup() {
        return this.configuration.isTestConnectionOnStartup();
    }

    @ManagedAttribute
    public void setTestConnectionOnStartup(boolean testConnectionOnStartup) {
        this.configuration.setTestConnectionOnStartup(testConnectionOnStartup);
    }

    @ManagedAttribute
    public boolean isForceSendOriginalMessage() {
        return this.configuration.isForceSendOriginalMessage();
    }

    @ManagedAttribute
    public void setForceSendOriginalMessage(boolean forceSendOriginalMessage) {
        this.configuration.setForceSendOriginalMessage(forceSendOriginalMessage);
    }

    @ManagedAttribute
    public boolean isDisableTimeToLive() {
        return this.configuration.isDisableTimeToLive();
    }

    @ManagedAttribute
    public void setDisableTimeToLive(boolean disableTimeToLive) {
        this.configuration.setDisableTimeToLive(disableTimeToLive);
    }

    @ManagedAttribute
    public void setAsyncConsumer(boolean asyncConsumer) {
        this.configuration.setAsyncConsumer(asyncConsumer);
    }

    @ManagedAttribute
    public boolean isAsyncConsumer() {
        return this.configuration.isAsyncConsumer();
    }

    @ManagedAttribute
    public void setAsyncStartListener(boolean asyncStartListener) {
        this.configuration.setAsyncStartListener(asyncStartListener);
    }

    @ManagedAttribute
    public boolean isAsyncStartListener() {
        return this.configuration.isAsyncStartListener();
    }

    @ManagedAttribute
    public void setAsyncStopListener(boolean asyncStopListener) {
        this.configuration.setAsyncStopListener(asyncStopListener);
    }

    @ManagedAttribute
    public boolean isAsyncStopListener() {
        return this.configuration.isAsyncStopListener();
    }

    @ManagedAttribute
    public boolean isAllowNullBody() {
        return this.configuration.isAllowNullBody();
    }

    @ManagedAttribute
    public void setAllowNullBody(boolean allowNullBody) {
        this.configuration.setAllowNullBody(allowNullBody);
    }

    @ManagedAttribute
    public boolean isIncludeSentJMSMessageID() {
        return this.configuration.isIncludeSentJMSMessageID();
    }

    @ManagedAttribute
    public void setIncludeSentJMSMessageID(boolean includeSentJMSMessageID) {
        this.configuration.setIncludeSentJMSMessageID(includeSentJMSMessageID);
    }

    @ManagedAttribute
    public boolean isIncludeAllJMSXProperties() {
        return this.configuration.isIncludeAllJMSXProperties();
    }

    @ManagedAttribute
    public void setIncludeAllJMSXProperties(boolean includeAllJMSXProperties) {
        this.configuration.setIncludeAllJMSXProperties(includeAllJMSXProperties);
    }

    @ManagedAttribute
    public DefaultTaskExecutorType getDefaultTaskExecutorType() {
        return this.configuration.getDefaultTaskExecutorType();
    }

    public void setDefaultTaskExecutorType(DefaultTaskExecutorType type) {
        this.configuration.setDefaultTaskExecutorType(type);
    }

    @ManagedAttribute
    public String getAllowAdditionalHeaders() {
        return this.configuration.getAllowAdditionalHeaders();
    }

    @ManagedAttribute
    public void setAllowAdditionalHeaders(String allowAdditionalHeaders) {
        this.configuration.setAllowAdditionalHeaders(allowAdditionalHeaders);
    }

    public MessageListenerContainerFactory getMessageListenerContainerFactory() {
        return this.configuration.getMessageListenerContainerFactory();
    }

    public void setMessageListenerContainerFactory(MessageListenerContainerFactory messageListenerContainerFactory) {
        this.configuration.setMessageListenerContainerFactory(messageListenerContainerFactory);
        this.configuration.setConsumerType(ConsumerType.Custom);
    }

    @ManagedAttribute
    public boolean isSubscriptionDurable() {
        return this.getConfiguration().isSubscriptionDurable();
    }

    @ManagedAttribute
    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.getConfiguration().setSubscriptionDurable(subscriptionDurable);
    }

    @ManagedAttribute
    public boolean isSubscriptionShared() {
        return this.getConfiguration().isSubscriptionShared();
    }

    @ManagedAttribute
    public void setSubscriptionShared(boolean subscriptionShared) {
        this.getConfiguration().setSubscriptionShared(subscriptionShared);
    }

    @ManagedAttribute
    public String getSubscriptionName() {
        return this.getConfiguration().getSubscriptionName();
    }

    @ManagedAttribute
    public void setSubscriptionName(String subscriptionName) {
        this.getConfiguration().setSubscriptionName(subscriptionName);
    }

    @ManagedAttribute
    public String getReplyToType() {
        if (this.configuration.getReplyToType() != null) {
            return this.configuration.getReplyToType().name();
        }
        return null;
    }

    @ManagedAttribute
    public void setReplyToType(String replyToType) {
        ReplyToType type = ReplyToType.valueOf(replyToType);
        this.configuration.setReplyToType(type);
    }

    @ManagedAttribute(description="Number of running message listeners")
    public int getRunningMessageListeners() {
        return this.runningMessageListeners.get();
    }

    @ManagedAttribute
    public String getSelector() {
        return this.configuration.getSelector();
    }

    public void setSelector(String selector) {
        this.configuration.setSelector(selector);
    }

    @ManagedAttribute
    public int getWaitForProvisionCorrelationToBeUpdatedCounter() {
        return this.configuration.getWaitForProvisionCorrelationToBeUpdatedCounter();
    }

    @ManagedAttribute
    public void setWaitForProvisionCorrelationToBeUpdatedCounter(int counter) {
        this.configuration.setWaitForProvisionCorrelationToBeUpdatedCounter(counter);
    }

    @ManagedAttribute
    public long getWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime() {
        return this.configuration.getWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime();
    }

    @ManagedAttribute
    public void setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime(long sleepingTime) {
        this.configuration.setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime(sleepingTime);
    }

    @ManagedAttribute
    public boolean isFormatDateHeadersToIso8601() {
        return this.configuration.isFormatDateHeadersToIso8601();
    }

    @ManagedAttribute
    public void setFormatDateHeadersToIso8601(boolean formatDateHeadersToIso8601) {
        this.configuration.setFormatDateHeadersToIso8601(formatDateHeadersToIso8601);
    }

    @ManagedAttribute
    public boolean isArtemisStreamingEnabled() {
        return this.configuration.isArtemisStreamingEnabled();
    }

    @ManagedAttribute
    public void setArtemisStreamingEnabled(boolean artemisStreamingEnabled) {
        this.configuration.setArtemisStreamingEnabled(artemisStreamingEnabled);
    }

    @Override
    protected String createEndpointUri() {
        String scheme = "jms";
        if (this.destinationName != null) {
            return scheme + ":" + this.destinationName;
        }
        DestinationResolver resolver = this.getDestinationResolver();
        if (resolver != null) {
            return scheme + ":" + String.valueOf(resolver);
        }
        return super.createEndpointUri();
    }
}

