/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import org.apache.camel.TimeoutMap;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.support.DefaultTimeoutMap;

class CorrelationTimeoutMap
extends DefaultTimeoutMap<String, ReplyHandler> {
    private final BiConsumer<ReplyHandler, String> evictionTask;

    CorrelationTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis, ExecutorService executorService) {
        super(executor, requestMapPollTimeMillis);
        this.evictionTask = executorService == null ? ReplyHandler::onTimeout : (handler, key) -> executorService.submit(() -> handler.onTimeout((String)key));
        this.addListener(this::listener);
    }

    private static long encode(long timeoutMillis) {
        return timeoutMillis > 0L ? timeoutMillis : Integer.MAX_VALUE;
    }

    private void listener(TimeoutMap.Listener.Type type, String key, ReplyHandler handler) {
        if (type == TimeoutMap.Listener.Type.Put) {
            this.log.trace("Added correlationID: {}", (Object)key);
        } else if (type == TimeoutMap.Listener.Type.Remove) {
            this.log.trace("Removed correlationID: {}", (Object)key);
        } else if (type == TimeoutMap.Listener.Type.Evict) {
            this.evictionTask.accept(handler, key);
            this.log.trace("Evicted correlationID: {}", (Object)key);
        }
    }

    @Override
    public ReplyHandler put(String key, ReplyHandler value, long timeoutMillis) {
        return super.put(key, value, CorrelationTimeoutMap.encode(timeoutMillis));
    }

    @Override
    public ReplyHandler putIfAbsent(String key, ReplyHandler value, long timeoutMillis) {
        return super.putIfAbsent(key, value, CorrelationTimeoutMap.encode(timeoutMillis));
    }
}

