/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.Optional;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.event.EventComponent;
import org.apache.camel.component.event.EventEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.BeanProcessorFactory;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.spi.ApplicationContextBeanRepository;
import org.apache.camel.spring.spi.SpringInjector;
import org.apache.camel.spring.spi.SpringManagementMBeanAssembler;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.ProcessorEndpoint;
import org.apache.camel.support.ResolverHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.Lifecycle;
import org.springframework.context.Phased;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class SpringCamelContext
extends DefaultCamelContext
implements Lifecycle,
ApplicationContextAware,
Phased,
ApplicationListener<ApplicationEvent>,
Ordered {
    public static final String EXCLUDE_ROUTES = "CamelTestSpringExcludeRoutes";
    private static final Logger LOG = LoggerFactory.getLogger(SpringCamelContext.class);
    private ApplicationContext applicationContext;
    private EventComponent eventComponent;
    private boolean shutdownEager = true;

    public SpringCamelContext() {
        super(false);
        this.getCamelContextExtension().setManagementMBeanAssembler(new SpringManagementMBeanAssembler(this));
    }

    public SpringCamelContext(ApplicationContext applicationContext) {
        this();
        this.setApplicationContext(applicationContext);
        this.getInjector();
    }

    @Deprecated
    public static SpringCamelContext springCamelContext(ApplicationContext applicationContext, boolean maybeStart) throws Exception {
        String[] names;
        if (applicationContext != null && (names = applicationContext.getBeanNamesForType(SpringCamelContext.class)).length == 1) {
            return applicationContext.getBean(names[0], SpringCamelContext.class);
        }
        SpringCamelContext answer = new SpringCamelContext();
        answer.setApplicationContext(applicationContext);
        answer.build();
        if (maybeStart) {
            answer.start();
        }
        return answer;
    }

    @Override
    public void doBuild() throws Exception {
        super.doBuild();
        if (this.applicationContext instanceof ConfigurableApplicationContext && this.hasComponent("spring-event") == null) {
            this.eventComponent = new EventComponent(this.applicationContext);
            this.addComponent("spring-event", this.eventComponent);
        }
    }

    @Override
    public void start() {
        try {
            super.start();
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void stop() {
        try {
            super.stop();
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        LOG.debug("onApplicationEvent: {}", (Object)event);
        if (event instanceof ContextRefreshedEvent && ((ContextRefreshedEvent)event).getApplicationContext() == this.applicationContext) {
            this.start();
        }
        if (this.eventComponent != null) {
            this.eventComponent.onApplicationEvent(event);
        }
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ClassLoader cl;
        this.applicationContext = applicationContext;
        if (applicationContext != null && applicationContext.getClassLoader() != null) {
            cl = applicationContext.getClassLoader();
        } else {
            LOG.warn("Cannot find the class loader from application context, using the thread context class loader instead");
            cl = Thread.currentThread().getContextClassLoader();
        }
        LOG.debug("Set the application context classloader to: {}", (Object)cl);
        this.setApplicationContextClassLoader(cl);
    }

    public boolean isShutdownEager() {
        return this.shutdownEager;
    }

    public void setShutdownEager(boolean shutdownEager) {
        this.shutdownEager = shutdownEager;
    }

    @Override
    protected Injector createInjector() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            return new SpringInjector((ConfigurableApplicationContext)this.applicationContext);
        }
        LOG.warn("Cannot use SpringInjector as applicationContext is not a ConfigurableApplicationContext as its: {}", (Object)this.applicationContext);
        return super.createInjector();
    }

    protected EventEndpoint createEventEndpoint() {
        return this.getEndpoint("spring-event:default", EventEndpoint.class);
    }

    @Override
    protected Endpoint convertBeanToEndpoint(String uri, Object bean2) {
        Endpoint endpoint = this.getTypeConverter().convertTo(Endpoint.class, bean2);
        if (endpoint != null) {
            endpoint.setCamelContext(this);
            return endpoint;
        }
        BeanProcessorFactory bpf = PluginHelper.getBeanProcessorFactory(this.getCamelContextExtension());
        try {
            Processor bp = bpf.createBeanProcessor(this, bean2, null);
            return new ProcessorEndpoint(uri, this, bp);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    @Override
    protected Registry createRegistry() {
        ApplicationContextBeanRepository repository = new ApplicationContextBeanRepository(this.getApplicationContext());
        return new DefaultRegistry(repository);
    }

    @Override
    protected ModelJAXBContextFactory createModelJAXBContextFactory() {
        Optional<ModelJAXBContextFactory> result = ResolverHelper.resolveService(this.getCamelContextReference(), this.getCamelContextExtension().getBootstrapFactoryFinder(), "model-jaxbcontext-factory-spring", ModelJAXBContextFactory.class);
        if (result.isPresent()) {
            return result.get();
        }
        throw new IllegalArgumentException("Cannot find ModelJAXBContextFactory on classpath. Add camel-spring-xml to classpath.");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("SpringCamelContext(").append(this.getName()).append(")");
        if (this.applicationContext != null) {
            sb.append(" with spring id ").append(this.applicationContext.getId());
        }
        return sb.toString();
    }

    @Override
    public int getPhase() {
        return 0x7FFFF7FE;
    }

    @Override
    public boolean isRunning() {
        return !this.isStopping() && !this.isStopped();
    }
}

