/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import jakarta.jms.MessageEOFException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.qpid.jms.message.JmsStreamMessage;
import org.apache.qpid.jms.message.facade.JmsStreamMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Section;

public class AmqpJmsStreamMessageFacade
extends AmqpJmsMessageFacade
implements JmsStreamMessageFacade {
    private List<Object> list;
    private int position = 0;

    @Override
    public AmqpJmsStreamMessageFacade copy() {
        AmqpJmsStreamMessageFacade copy = new AmqpJmsStreamMessageFacade();
        this.copyInto(copy);
        copy.initializeEmptyBodyList(this.getBody() instanceof AmqpSequence);
        copy.list.addAll(this.list);
        return copy;
    }

    @Override
    public byte getJmsMsgType() {
        return 4;
    }

    @Override
    public boolean hasNext() {
        return !this.list.isEmpty() && this.position < this.list.size();
    }

    @Override
    public Object peek() throws MessageEOFException {
        if (this.list.isEmpty() || this.position >= this.list.size()) {
            throw new MessageEOFException("Attempt to read past end of stream");
        }
        Object object = this.list.get(this.position);
        if (object instanceof Binary) {
            Binary bin = (Binary)object;
            object = Arrays.copyOfRange(bin.getArray(), bin.getArrayOffset(), bin.getLength());
        }
        return object;
    }

    @Override
    public void pop() throws MessageEOFException {
        if (this.list.isEmpty() || this.position >= this.list.size()) {
            throw new MessageEOFException("Attempt to read past end of stream");
        }
        ++this.position;
    }

    @Override
    public void put(Object value) {
        Object entry = value;
        if (entry instanceof byte[]) {
            entry = new Binary((byte[])value);
        }
        this.list.add(entry);
    }

    @Override
    public void reset() {
        this.position = 0;
    }

    @Override
    public void clearBody() {
        this.list.clear();
        this.position = 0;
    }

    @Override
    public boolean hasBody() {
        return !this.list.isEmpty();
    }

    @Override
    public JmsStreamMessage asJmsMessage() {
        return new JmsStreamMessage(this);
    }

    @Override
    protected void initializeEmptyBody() {
        this.list = this.initializeEmptyBodyList(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void setBody(Section body) {
        if (body == null) {
            this.list = this.initializeEmptyBodyList(true);
            return;
        } else if (body instanceof AmqpValue) {
            Object value = ((AmqpValue)body).getValue();
            if (value == null) {
                this.list = this.initializeEmptyBodyList(false);
                return;
            } else {
                if (!(value instanceof List)) throw new IllegalStateException("Unexpected amqp-value body content type: " + value.getClass().getSimpleName());
                this.list = (List)value;
                super.setBody(body);
            }
            return;
        } else {
            if (!(body instanceof AmqpSequence)) throw new IllegalStateException("Unexpected message body type: " + body.getClass().getSimpleName());
            List value = ((AmqpSequence)body).getValue();
            if (value == null) {
                this.list = this.initializeEmptyBodyList(true);
                return;
            } else {
                this.list = value;
                super.setBody(body);
            }
        }
    }

    private List<Object> initializeEmptyBodyList(boolean useSequenceBody) {
        ArrayList<Object> emptyList = new ArrayList<Object>();
        if (useSequenceBody) {
            this.setBody(new AmqpSequence(emptyList));
        } else {
            this.setBody(new AmqpValue(emptyList));
        }
        return emptyList;
    }
}

