/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class AmqpReadableBuffer
implements ReadableBuffer {
    private ByteBuf buffer;

    public AmqpReadableBuffer(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public ByteBuf getBuffer() {
        return this.buffer;
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public ReadableBuffer reclaimRead() {
        return this;
    }

    @Override
    public byte get() {
        return this.buffer.readByte();
    }

    @Override
    public byte get(int index) {
        return this.buffer.getByte(index);
    }

    @Override
    public int getInt() {
        return this.buffer.readInt();
    }

    @Override
    public long getLong() {
        return this.buffer.readLong();
    }

    @Override
    public short getShort() {
        return this.buffer.readShort();
    }

    @Override
    public float getFloat() {
        return this.buffer.readFloat();
    }

    @Override
    public double getDouble() {
        return this.buffer.readDouble();
    }

    @Override
    public ReadableBuffer get(byte[] target, int offset, int length) {
        this.buffer.readBytes(target, offset, length);
        return this;
    }

    @Override
    public ReadableBuffer get(byte[] target) {
        this.buffer.readBytes(target);
        return this;
    }

    @Override
    public ReadableBuffer get(WritableBuffer target) {
        int start = target.position();
        if (this.buffer.hasArray()) {
            target.put(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.readerIndex(), this.buffer.readableBytes());
        } else {
            target.put(this.buffer.nioBuffer());
        }
        int written = target.position() - start;
        this.buffer.readerIndex(this.buffer.readerIndex() + written);
        return this;
    }

    @Override
    public ReadableBuffer slice() {
        return new AmqpReadableBuffer(this.buffer.slice());
    }

    @Override
    public ReadableBuffer flip() {
        this.buffer.setIndex(0, this.buffer.readerIndex());
        return this;
    }

    @Override
    public ReadableBuffer limit(int limit) {
        this.buffer.writerIndex(limit);
        return this;
    }

    @Override
    public int limit() {
        return this.buffer.writerIndex();
    }

    @Override
    public ReadableBuffer position(int position) {
        this.buffer.readerIndex(position);
        return this;
    }

    @Override
    public int position() {
        return this.buffer.readerIndex();
    }

    @Override
    public ReadableBuffer mark() {
        this.buffer.markReaderIndex();
        return this;
    }

    @Override
    public ReadableBuffer reset() {
        this.buffer.resetReaderIndex();
        return this;
    }

    @Override
    public ReadableBuffer rewind() {
        this.buffer.readerIndex(0);
        return this;
    }

    @Override
    public ReadableBuffer clear() {
        this.buffer.setIndex(0, this.buffer.capacity());
        return this;
    }

    @Override
    public int remaining() {
        return this.buffer.readableBytes();
    }

    @Override
    public boolean hasRemaining() {
        return this.buffer.isReadable();
    }

    @Override
    public ReadableBuffer duplicate() {
        return new AmqpReadableBuffer(this.buffer.duplicate());
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.buffer.nioBuffer();
    }

    @Override
    public String readUTF8() throws CharacterCodingException {
        return this.buffer.readCharSequence(this.buffer.readableBytes(), StandardCharsets.UTF_8).toString();
    }

    @Override
    public String readString(CharsetDecoder decoder) throws CharacterCodingException {
        return this.buffer.readCharSequence(this.buffer.readableBytes(), decoder.charset()).toString();
    }
}

