/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class AmqpWritableBuffer
implements WritableBuffer {
    public static final int INITIAL_CAPACITY = 1024;
    public ByteBuf nettyBuffer;

    public AmqpWritableBuffer() {
        this.nettyBuffer = Unpooled.buffer(1024);
    }

    public AmqpWritableBuffer(ByteBuf buffer) {
        this.nettyBuffer = buffer;
    }

    public ByteBuf getBuffer() {
        return this.nettyBuffer;
    }

    @Override
    public void put(byte b) {
        this.nettyBuffer.writeByte(b);
    }

    @Override
    public void putFloat(float f) {
        this.nettyBuffer.writeFloat(f);
    }

    @Override
    public void putDouble(double d) {
        this.nettyBuffer.writeDouble(d);
    }

    @Override
    public void put(byte[] src, int offset, int length) {
        this.nettyBuffer.writeBytes(src, offset, length);
    }

    @Override
    public void put(ByteBuffer payload) {
        this.nettyBuffer.writeBytes(payload);
    }

    public void put(ByteBuf payload) {
        this.nettyBuffer.writeBytes(payload);
    }

    @Override
    public void putShort(short s) {
        this.nettyBuffer.writeShort(s);
    }

    @Override
    public void putInt(int i2) {
        this.nettyBuffer.writeInt(i2);
    }

    @Override
    public void putLong(long l) {
        this.nettyBuffer.writeLong(l);
    }

    @Override
    public void put(String value) {
        this.nettyBuffer.writeCharSequence(value, StandardCharsets.UTF_8);
    }

    @Override
    public boolean hasRemaining() {
        return this.nettyBuffer.writerIndex() < this.nettyBuffer.maxCapacity();
    }

    @Override
    public int remaining() {
        return this.nettyBuffer.maxCapacity() - this.nettyBuffer.writerIndex();
    }

    @Override
    public void ensureRemaining(int remaining) {
        this.nettyBuffer.ensureWritable(remaining);
    }

    @Override
    public int position() {
        return this.nettyBuffer.writerIndex();
    }

    @Override
    public void position(int position) {
        this.nettyBuffer.writerIndex(position);
    }

    @Override
    public int limit() {
        return this.nettyBuffer.capacity();
    }

    @Override
    public void put(ReadableBuffer buffer) {
        buffer.get(this);
    }
}

