/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.jms.transports.netty.EventLoopGroupRef;
import org.apache.qpid.jms.transports.netty.EventLoopType;
import org.apache.qpid.jms.util.QpidJMSThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyEventLoopGroupFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NettyEventLoopGroupFactory.class);
    private static final AtomicLong SHARED_EVENT_LOOP_GROUP_INSTANCE_SEQUENCE = new AtomicLong(0L);
    private static final int SHUTDOWN_TIMEOUT = 50;
    private static final Map<EventLoopGroupKey, EventLoopGroupHolder> SHARED_EVENT_LOOP_GROUPS = new HashMap<EventLoopGroupKey, EventLoopGroupHolder>();

    private NettyEventLoopGroupFactory() {
    }

    public static EventLoopGroupRef unsharedGroup(EventLoopType type, ThreadFactory threadFactory) {
        Objects.requireNonNull(type);
        final EventLoopGroup unsharedGroup = type.createEventLoopGroup(1, threadFactory);
        return new EventLoopGroupRef(){

            @Override
            public EventLoopGroup group() {
                return unsharedGroup;
            }

            @Override
            public void close() {
                NettyEventLoopGroupFactory.shutdownEventLoopGroup(unsharedGroup);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventLoopGroupRef sharedGroup(EventLoopType type, int threads) {
        Objects.requireNonNull(type);
        if (threads <= 0) {
            throw new IllegalArgumentException("shared event loop threads value must be > 0");
        }
        EventLoopGroupKey key = new EventLoopGroupKey(type, threads);
        Map<EventLoopGroupKey, EventLoopGroupHolder> map = SHARED_EVENT_LOOP_GROUPS;
        synchronized (map) {
            EventLoopGroupHolder groupHolder = SHARED_EVENT_LOOP_GROUPS.get(key);
            if (groupHolder == null) {
                groupHolder = new EventLoopGroupHolder(NettyEventLoopGroupFactory.createSharedEventLoopGroup(type, threads), key);
                SHARED_EVENT_LOOP_GROUPS.put(key, groupHolder);
            } else {
                groupHolder.incRef();
            }
            return new SharedEventLoopGroupRef(groupHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sharedGroupRefClosed(EventLoopGroupHolder holder) {
        boolean shutdown = false;
        Map<EventLoopGroupKey, EventLoopGroupHolder> map = SHARED_EVENT_LOOP_GROUPS;
        synchronized (map) {
            if (holder.decRef()) {
                SHARED_EVENT_LOOP_GROUPS.remove(holder.key());
                shutdown = true;
            }
        }
        if (shutdown) {
            NettyEventLoopGroupFactory.shutdownEventLoopGroup(holder.group());
        }
    }

    private static void shutdownEventLoopGroup(EventLoopGroup group) {
        Future<?> fut = group.shutdownGracefully(0L, 50L, TimeUnit.MILLISECONDS);
        if (!fut.awaitUninterruptibly(100L)) {
            LOG.trace("Channel group shutdown failed to complete in allotted time");
        }
    }

    private static ThreadFactory createSharedThreadFactory(EventLoopType type, int threads) {
        String baseName = "SharedNettyEventLoopGroup (" + SHARED_EVENT_LOOP_GROUP_INSTANCE_SEQUENCE.incrementAndGet() + ")[" + type + " - size=" + threads + "]:";
        return new QpidJMSThreadFactory(thread -> baseName + " thread-id=" + thread.getId(), true);
    }

    private static EventLoopGroup createSharedEventLoopGroup(EventLoopType type, int threads) {
        return type.createEventLoopGroup(threads, NettyEventLoopGroupFactory.createSharedThreadFactory(type, threads));
    }

    private static final class EventLoopGroupHolder {
        private final EventLoopGroup group;
        private final EventLoopGroupKey key;
        private int refCnt = 1;

        private EventLoopGroupHolder(EventLoopGroup sharedGroup, EventLoopGroupKey key) {
            this.group = Objects.requireNonNull(sharedGroup);
            this.key = Objects.requireNonNull(key);
        }

        public EventLoopGroup group() {
            return this.group;
        }

        public EventLoopGroupKey key() {
            return this.key;
        }

        public void incRef() {
            assert (Thread.holdsLock(SHARED_EVENT_LOOP_GROUPS));
            if (this.refCnt == 0) {
                throw new IllegalStateException("The group was already released, can not increment reference count.");
            }
            ++this.refCnt;
        }

        public boolean decRef() {
            assert (Thread.holdsLock(SHARED_EVENT_LOOP_GROUPS));
            if (this.refCnt == 0) {
                throw new IllegalStateException("The group was already released, can not decrement reference count.");
            }
            --this.refCnt;
            return this.refCnt == 0;
        }
    }

    private static class EventLoopGroupKey {
        private final EventLoopType type;
        private final int eventLoopThreads;

        private EventLoopGroupKey(EventLoopType type, int eventLoopThreads) {
            this.type = type;
            this.eventLoopThreads = eventLoopThreads;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventLoopGroupKey that = (EventLoopGroupKey)o;
            if (this.eventLoopThreads != that.eventLoopThreads) {
                return false;
            }
            return this.type == that.type;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + this.eventLoopThreads;
            return result;
        }
    }

    private static final class SharedEventLoopGroupRef
    implements EventLoopGroupRef {
        private final EventLoopGroupHolder sharedGroupHolder;
        private final AtomicBoolean closed = new AtomicBoolean();

        public SharedEventLoopGroupRef(EventLoopGroupHolder sharedGroupHolder) {
            this.sharedGroupHolder = Objects.requireNonNull(sharedGroupHolder);
        }

        @Override
        public EventLoopGroup group() {
            if (this.closed.get()) {
                throw new IllegalStateException("Group reference is already closed");
            }
            return this.sharedGroupHolder.group();
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                NettyEventLoopGroupFactory.sharedGroupRefClosed(this.sharedGroupHolder);
            }
        }
    }
}

