/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.amqp;

public final class UnsignedByte
extends Number
implements Comparable<UnsignedByte> {
    private final byte _underlying;
    private static final UnsignedByte[] cachedValues = new UnsignedByte[256];

    public UnsignedByte(byte underlying) {
        this._underlying = underlying;
    }

    @Override
    public byte byteValue() {
        return this._underlying;
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public int intValue() {
        return this._underlying & 0xFF;
    }

    @Override
    public long longValue() {
        return (long)this._underlying & 0xFFL;
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsignedByte that = (UnsignedByte)o;
        return this._underlying == that._underlying;
    }

    @Override
    public int compareTo(UnsignedByte o) {
        return Integer.signum(this.intValue() - o.intValue());
    }

    public int hashCode() {
        return this._underlying;
    }

    public String toString() {
        return String.valueOf(this.intValue());
    }

    public static UnsignedByte valueOf(byte underlying) {
        int index = underlying & 0xFF;
        return cachedValues[index];
    }

    public static UnsignedByte valueOf(String value) throws NumberFormatException {
        int intVal = Integer.parseInt(value);
        if (intVal < 0 || intVal >= 256) {
            throw new NumberFormatException("Value \"" + value + "\" lies outside the range [" + 0 + "-" + 256 + ").");
        }
        return UnsignedByte.valueOf((byte)intVal);
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            UnsignedByte.cachedValues[i2] = new UnsignedByte((byte)i2);
        }
    }
}

