/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.amqp;

import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.PropertiesComponent;

public class AMQPConnectionDetails {
    public static final String AMQP_HOST = "AMQP_SERVICE_HOST";
    public static final String AMQP_PORT = "AMQP_SERVICE_PORT";
    public static final String AMQP_USERNAME = "AMQP_SERVICE_USERNAME";
    public static final String AMQP_PASSWORD = "AMQP_SERVICE_PASSWORD";
    public static final String AMQP_SET_TOPIC_PREFIX = "AMQP_SET_TOPIC_PREFIX";
    private final String uri;
    private final String username;
    private final String password;
    private final boolean setTopicPrefix;

    public AMQPConnectionDetails(String uri, String username, String password) {
        this.uri = uri;
        this.username = username;
        this.password = password;
        this.setTopicPrefix = true;
    }

    public AMQPConnectionDetails(String uri, String username, String password, boolean setTopicPrefix) {
        this.uri = uri;
        this.username = username;
        this.password = password;
        this.setTopicPrefix = setTopicPrefix;
    }

    public AMQPConnectionDetails(String uri) {
        this(uri, null, null);
    }

    public static AMQPConnectionDetails discoverAMQP(CamelContext camelContext) {
        try {
            PropertiesComponent propertiesComponent = camelContext.getPropertiesComponent();
            String host = AMQPConnectionDetails.property(propertiesComponent, AMQP_HOST, "localhost");
            int port = Integer.parseInt(AMQPConnectionDetails.property(propertiesComponent, AMQP_PORT, "5672"));
            String username = AMQPConnectionDetails.property(propertiesComponent, AMQP_USERNAME, null);
            String password = AMQPConnectionDetails.property(propertiesComponent, AMQP_PASSWORD, null);
            boolean setTopicPrefix = Boolean.parseBoolean(AMQPConnectionDetails.property(propertiesComponent, AMQP_SET_TOPIC_PREFIX, "true"));
            return new AMQPConnectionDetails("amqp://" + host + ":" + port, username, password, setTopicPrefix);
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    public String uri() {
        return this.uri;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public boolean setTopicPrefix() {
        return this.setTopicPrefix;
    }

    private static String property(PropertiesComponent propertiesComponent, String key, String defaultValue) {
        try {
            return propertiesComponent.parseUri("{{" + key + "}}");
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }
}

