/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.builders;

import java.util.HashMap;
import org.apache.qpid.jms.JmsTemporaryDestination;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.provider.amqp.AmqpTemporaryDestination;
import org.apache.qpid.jms.provider.amqp.builders.AmqpResourceBuilder;
import org.apache.qpid.jms.provider.amqp.message.AmqpDestinationHelper;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.DeleteOnClose;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTemporaryDestinationBuilder
extends AmqpResourceBuilder<AmqpTemporaryDestination, AmqpSession, JmsTemporaryDestination, Sender> {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpTemporaryDestinationBuilder.class);

    public AmqpTemporaryDestinationBuilder(AmqpSession parent, JmsTemporaryDestination resourceInfo) {
        super(parent, resourceInfo);
    }

    @Override
    protected Sender createEndpoint(JmsTemporaryDestination resourceInfo) {
        String localDestinationName = resourceInfo.getAddress();
        String senderLinkName = null;
        senderLinkName = resourceInfo.isQueue() ? "qpid-jms:temp-queue-creator:" + localDestinationName : "qpid-jms:temp-topic-creator:" + localDestinationName;
        Source source = new Source();
        Target target = new Target();
        target.setDynamic(true);
        target.setDurable(TerminusDurability.NONE);
        target.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        HashMap<Symbol, DeleteOnClose> dynamicNodeProperties = new HashMap<Symbol, DeleteOnClose>();
        dynamicNodeProperties.put(AmqpSupport.DYNAMIC_NODE_LIFETIME_POLICY, DeleteOnClose.getInstance());
        target.setDynamicNodeProperties(dynamicNodeProperties);
        if (resourceInfo.isQueue()) {
            target.setCapabilities(AmqpDestinationHelper.TEMP_QUEUE_CAPABILITY);
        } else {
            target.setCapabilities(AmqpDestinationHelper.TEMP_TOPIC_CAPABILITY);
        }
        Sender sender = ((Session)((AmqpSession)this.getParent()).getEndpoint()).sender(senderLinkName);
        sender.setSource(source);
        sender.setTarget(target);
        sender.setSenderSettleMode(SenderSettleMode.UNSETTLED);
        sender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        return sender;
    }

    @Override
    protected AmqpTemporaryDestination createResource(AmqpSession parent, JmsTemporaryDestination resourceInfo, Sender endpoint) {
        return new AmqpTemporaryDestination((AmqpSession)this.getParent(), (JmsTemporaryDestination)this.getResourceInfo(), endpoint);
    }

    @Override
    protected boolean isClosePending() {
        return ((Sender)this.getEndpoint()).getRemoteTarget() == null;
    }

    @Override
    protected void afterOpened() {
        if (!this.isClosePending()) {
            String oldDestinationName = ((JmsTemporaryDestination)this.resourceInfo).getAddress();
            String destinationName = ((Sender)this.getEndpoint()).getRemoteTarget().getAddress();
            ((JmsTemporaryDestination)this.resourceInfo).setAddress(destinationName);
            LOG.trace("Updated temp destination to: {} from: {}", (Object)destinationName, (Object)oldDestinationName);
        }
    }
}

