/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.qpid.jms.exceptions.IdConversionException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.UnsignedLong;

public class AmqpMessageIdHelper {
    public static final String AMQP_STRING_PREFIX = "AMQP_STRING:";
    public static final String AMQP_UUID_PREFIX = "AMQP_UUID:";
    public static final String AMQP_ULONG_PREFIX = "AMQP_ULONG:";
    public static final String AMQP_BINARY_PREFIX = "AMQP_BINARY:";
    public static final String AMQP_NO_PREFIX = "AMQP_NO_PREFIX:";
    public static final String JMS_ID_PREFIX = "ID:";
    private static final String AMQP_PREFIX = "AMQP_";
    private static final int JMS_ID_PREFIX_LENGTH = "ID:".length();
    private static final int AMQP_UUID_PREFIX_LENGTH = "AMQP_UUID:".length();
    private static final int AMQP_ULONG_PREFIX_LENGTH = "AMQP_ULONG:".length();
    private static final int AMQP_STRING_PREFIX_LENGTH = "AMQP_STRING:".length();
    private static final int AMQP_BINARY_PREFIX_LENGTH = "AMQP_BINARY:".length();
    private static final int AMQP_NO_PREFIX_LENGTH = "AMQP_NO_PREFIX:".length();
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();

    public static boolean hasMessageIdPrefix(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith(JMS_ID_PREFIX);
    }

    public static String toMessageIdString(Object idObject) {
        if (idObject instanceof String) {
            String stringId = (String)idObject;
            boolean hasMessageIdPrefix = AmqpMessageIdHelper.hasMessageIdPrefix(stringId);
            if (!hasMessageIdPrefix) {
                return "ID:AMQP_NO_PREFIX:" + stringId;
            }
            if (AmqpMessageIdHelper.hasTypeEncodingPrefix(stringId, JMS_ID_PREFIX_LENGTH)) {
                return "ID:AMQP_STRING:" + stringId;
            }
            return stringId;
        }
        return AmqpMessageIdHelper.convertToIdString(idObject);
    }

    public static String toCorrelationIdString(Object idObject) {
        if (idObject instanceof String) {
            String stringId = (String)idObject;
            boolean hasMessageIdPrefix = AmqpMessageIdHelper.hasMessageIdPrefix(stringId);
            if (!hasMessageIdPrefix) {
                return stringId;
            }
            if (AmqpMessageIdHelper.hasTypeEncodingPrefix(stringId, JMS_ID_PREFIX_LENGTH)) {
                return "ID:AMQP_STRING:" + stringId;
            }
            return stringId;
        }
        return AmqpMessageIdHelper.convertToIdString(idObject);
    }

    private static String convertToIdString(Object idObject) {
        if (idObject == null) {
            return null;
        }
        if (idObject instanceof UUID) {
            return "ID:AMQP_UUID:" + idObject.toString();
        }
        if (idObject instanceof UnsignedLong) {
            return "ID:AMQP_ULONG:" + idObject.toString();
        }
        if (idObject instanceof Binary) {
            ByteBuffer dup = ((Binary)idObject).asByteBuffer();
            byte[] bytes = new byte[dup.remaining()];
            dup.get(bytes);
            String hex = AmqpMessageIdHelper.convertBinaryToHexString(bytes);
            return "ID:AMQP_BINARY:" + hex;
        }
        throw new IllegalArgumentException("Unsupported type provided: " + idObject.getClass());
    }

    private static boolean hasTypeEncodingPrefix(String stringId, int offset) {
        if (!stringId.startsWith(AMQP_PREFIX, offset)) {
            return false;
        }
        return AmqpMessageIdHelper.hasAmqpBinaryPrefix(stringId, offset) || AmqpMessageIdHelper.hasAmqpUuidPrefix(stringId, offset) || AmqpMessageIdHelper.hasAmqpUlongPrefix(stringId, offset) || AmqpMessageIdHelper.hasAmqpStringPrefix(stringId, offset) || AmqpMessageIdHelper.hasAmqpNoPrefix(stringId, offset);
    }

    private static boolean hasAmqpStringPrefix(String stringId, int offset) {
        return stringId.startsWith(AMQP_STRING_PREFIX, offset);
    }

    private static boolean hasAmqpUlongPrefix(String stringId, int offset) {
        return stringId.startsWith(AMQP_ULONG_PREFIX, offset);
    }

    private static boolean hasAmqpUuidPrefix(String stringId, int offset) {
        return stringId.startsWith(AMQP_UUID_PREFIX, offset);
    }

    private static boolean hasAmqpBinaryPrefix(String stringId, int offset) {
        return stringId.startsWith(AMQP_BINARY_PREFIX, offset);
    }

    private static boolean hasAmqpNoPrefix(String stringId, int offset) {
        return stringId.startsWith(AMQP_NO_PREFIX, offset);
    }

    public static Object toIdObject(String origId) throws IdConversionException {
        if (origId == null) {
            return null;
        }
        if (!AmqpMessageIdHelper.hasMessageIdPrefix(origId)) {
            return origId;
        }
        try {
            if (AmqpMessageIdHelper.hasAmqpNoPrefix(origId, JMS_ID_PREFIX_LENGTH)) {
                return origId.substring(JMS_ID_PREFIX_LENGTH + AMQP_NO_PREFIX_LENGTH);
            }
            if (AmqpMessageIdHelper.hasAmqpUuidPrefix(origId, JMS_ID_PREFIX_LENGTH)) {
                String uuidString = origId.substring(JMS_ID_PREFIX_LENGTH + AMQP_UUID_PREFIX_LENGTH);
                return UUID.fromString(uuidString);
            }
            if (AmqpMessageIdHelper.hasAmqpUlongPrefix(origId, JMS_ID_PREFIX_LENGTH)) {
                String ulongString = origId.substring(JMS_ID_PREFIX_LENGTH + AMQP_ULONG_PREFIX_LENGTH);
                return UnsignedLong.valueOf(ulongString);
            }
            if (AmqpMessageIdHelper.hasAmqpStringPrefix(origId, JMS_ID_PREFIX_LENGTH)) {
                return origId.substring(JMS_ID_PREFIX_LENGTH + AMQP_STRING_PREFIX_LENGTH);
            }
            if (AmqpMessageIdHelper.hasAmqpBinaryPrefix(origId, JMS_ID_PREFIX_LENGTH)) {
                String hexString = origId.substring(JMS_ID_PREFIX_LENGTH + AMQP_BINARY_PREFIX_LENGTH);
                byte[] bytes = AmqpMessageIdHelper.convertHexStringToBinary(hexString);
                return new Binary(bytes);
            }
            return origId;
        }
        catch (IllegalArgumentException e) {
            throw new IdConversionException("Unable to convert ID value", e);
        }
    }

    public static byte[] convertHexStringToBinary(String hexString) throws IllegalArgumentException {
        int length = hexString.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("The provided hex String must be an even length, but was of length " + length + ": " + hexString);
        }
        byte[] binary = new byte[length / 2];
        for (int i2 = 0; i2 < length; i2 += 2) {
            char highBitsChar = hexString.charAt(i2);
            char lowBitsChar = hexString.charAt(i2 + 1);
            int highBits = AmqpMessageIdHelper.hexCharToInt(highBitsChar, hexString) << 4;
            int lowBits = AmqpMessageIdHelper.hexCharToInt(lowBitsChar, hexString);
            binary[i2 / 2] = (byte)(highBits + lowBits);
        }
        return binary;
    }

    private static int hexCharToInt(char ch, String orig) throws IllegalArgumentException {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("The provided hex string contains non-hex character '" + ch + "': " + orig);
    }

    public static String convertBinaryToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            int highBitsInt = b >> 4 & 0xF;
            int lowBitsInt = b & 0xF;
            builder.append(HEX_CHARS[highBitsInt]);
            builder.append(HEX_CHARS[lowBitsInt]);
        }
        return builder.toString();
    }
}

