/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.sasl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.qpid.jms.sasl.Mechanism;
import org.apache.qpid.jms.sasl.MechanismFactory;
import org.apache.qpid.jms.sasl.SaslSecurityRuntimeException;
import org.apache.qpid.jms.util.FactoryFinder;
import org.apache.qpid.jms.util.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslMechanismFinder {
    private static final Logger LOG = LoggerFactory.getLogger(SaslMechanismFinder.class);
    private static final FactoryFinder<MechanismFactory> MECHANISM_FACTORY_FINDER = new FactoryFinder<MechanismFactory>(MechanismFactory.class, "META-INF/services/" + SaslMechanismFinder.class.getPackage().getName().replace(".", "/") + "/");

    public static Mechanism findMatchingMechanism(String username, String password, Principal localPrincipal, Set<String> mechRestrictions, String ... remoteMechanisms) throws SaslSecurityRuntimeException {
        Mechanism match = null;
        ArrayList<Mechanism> found = new ArrayList<Mechanism>();
        List<String> remoteMechanismNames = Arrays.asList(remoteMechanisms);
        for (String remoteMechanism : remoteMechanismNames) {
            boolean mechConfigured;
            MechanismFactory factory = SaslMechanismFinder.findMechanismFactory(remoteMechanism);
            if (factory == null) continue;
            Mechanism mech = factory.createMechanism();
            boolean bl = mechConfigured = mechRestrictions != null && mechRestrictions.contains(remoteMechanism);
            if (mechRestrictions != null && !mechConfigured) {
                LOG.trace("Skipping {} mechanism because it is not in the configured mechanisms restriction set", (Object)remoteMechanism);
                continue;
            }
            if (mech.isApplicable(username, password, localPrincipal)) {
                if (mech.isEnabledByDefault() || mechConfigured) {
                    found.add(mech);
                    continue;
                }
                LOG.trace("Skipping {} mechanism as it must be explicitly enabled in the configured sasl mechanisms", (Object)mech);
                continue;
            }
            LOG.trace("Skipping {} mechanism because the available credentials are not sufficient", (Object)mech);
        }
        if (found.isEmpty()) {
            throw new SaslSecurityRuntimeException("No supported mechanism, or none usable with the available credentials. Server offered: " + remoteMechanismNames);
        }
        Collections.sort(found);
        match = (Mechanism)found.get(found.size() - 1);
        LOG.debug("Best match for SASL auth was: {}", (Object)match);
        return match;
    }

    protected static MechanismFactory findMechanismFactory(String name) {
        if (name == null || name.isEmpty()) {
            LOG.warn("No SASL mechanism name was specified");
            return null;
        }
        MechanismFactory factory = null;
        try {
            factory = MECHANISM_FACTORY_FINDER.newInstance(name);
        }
        catch (ResourceNotFoundException rnfe) {
            LOG.trace("Unknown SASL mechanism: [" + name + "]");
        }
        catch (Exception e) {
            LOG.warn("Caught exception while finding factory for SASL mechanism {}: {}", (Object)name, (Object)e.getMessage());
        }
        return factory;
    }
}

