/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Arrays;
import java.util.Collection;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class IntegerType
extends AbstractPrimitiveType<Integer> {
    private IntegerEncoding _integerEncoding;
    private IntegerEncoding _smallIntegerEncoding;

    IntegerType(EncoderImpl encoder, DecoderImpl decoder) {
        this._integerEncoding = new AllIntegerEncoding(encoder, decoder);
        this._smallIntegerEncoding = new SmallIntegerEncoding(encoder, decoder);
        encoder.register(Integer.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Integer> getTypeClass() {
        return Integer.class;
    }

    public IntegerEncoding getEncoding(Integer val) {
        return this.getEncoding((int)val);
    }

    public IntegerEncoding getEncoding(int i2) {
        return i2 >= -128 && i2 <= 127 ? this._smallIntegerEncoding : this._integerEncoding;
    }

    @Override
    public IntegerEncoding getCanonicalEncoding() {
        return this._integerEncoding;
    }

    @Override
    public Collection<IntegerEncoding> getAllEncodings() {
        return Arrays.asList(this._integerEncoding, this._smallIntegerEncoding);
    }

    @Override
    public void write(int i2) {
        if (i2 >= -128 && i2 <= 127) {
            this._smallIntegerEncoding.write(i2);
        } else {
            this._integerEncoding.write(i2);
        }
    }

    private class SmallIntegerEncoding
    extends FixedSizePrimitiveTypeEncoding<Integer>
    implements IntegerEncoding {
        public SmallIntegerEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        public byte getEncodingCode() {
            return 84;
        }

        @Override
        protected int getFixedSize() {
            return 1;
        }

        @Override
        public void write(int i2) {
            this.writeConstructor();
            this.getEncoder().writeRaw((byte)i2);
        }

        @Override
        public void writeValue(int i2) {
            this.getEncoder().writeRaw((byte)i2);
        }

        @Override
        public int readPrimitiveValue() {
            return this.getDecoder().readRawByte();
        }

        @Override
        public IntegerType getType() {
            return IntegerType.this;
        }

        @Override
        public void writeValue(Integer val) {
            this.getEncoder().writeRaw((byte)val.intValue());
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Integer> encoder) {
            return encoder == this;
        }

        @Override
        public Integer readValue() {
            return this.readPrimitiveValue();
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return true;
        }
    }

    private class AllIntegerEncoding
    extends FixedSizePrimitiveTypeEncoding<Integer>
    implements IntegerEncoding {
        public AllIntegerEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 4;
        }

        @Override
        public byte getEncodingCode() {
            return 113;
        }

        @Override
        public IntegerType getType() {
            return IntegerType.this;
        }

        @Override
        public void writeValue(Integer val) {
            this.getEncoder().writeRaw(val);
        }

        @Override
        public void write(int i2) {
            this.writeConstructor();
            this.getEncoder().writeRaw(i2);
        }

        @Override
        public void writeValue(int i2) {
            this.getEncoder().writeRaw(i2);
        }

        @Override
        public int readPrimitiveValue() {
            return this.getDecoder().readRawInt();
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Integer> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Integer readValue() {
            return this.readPrimitiveValue();
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return true;
        }
    }

    public static interface IntegerEncoding
    extends PrimitiveTypeEncoding<Integer> {
        public void write(int var1);

        @Override
        public void writeValue(int var1);

        public int readPrimitiveValue();
    }
}

