/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import org.apache.qpid.proton.amqp.Binary;

public class StringUtils {
    public static String toQuotedString(Binary bin, int stringLength, boolean appendIfTruncated) {
        if (bin == null) {
            return "\"\"";
        }
        byte[] binData = bin.getArray();
        int binLength = bin.getLength();
        int offset = bin.getArrayOffset();
        StringBuilder str = new StringBuilder();
        str.append("\"");
        int size = 0;
        boolean truncated = false;
        for (int i2 = 0; i2 < binLength; ++i2) {
            byte c = binData[offset + i2];
            if (c > 31 && c < 127 && c != 92) {
                if (size + 1 <= stringLength) {
                    ++size;
                    str.append((char)c);
                    continue;
                }
                truncated = true;
                break;
            }
            if (size + 4 <= stringLength) {
                size += 4;
                str.append(String.format("\\x%02x", c));
                continue;
            }
            truncated = true;
            break;
        }
        str.append("\"");
        if (truncated && appendIfTruncated) {
            str.append("...(truncated)");
        }
        return str.toString();
    }
}

