/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.kyber;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberEngine;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;

public class KyberKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private KyberParameters kyberParams;
    private SecureRandom random;

    private void initialize(KeyGenerationParameters param) {
        this.kyberParams = ((KyberKeyGenerationParameters)param).getParameters();
        this.random = param.getRandom();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        KyberEngine engine = this.kyberParams.getEngine();
        engine.init(this.random);
        byte[][] keyPair = engine.generateKemKeyPair();
        KyberPublicKeyParameters pubKey = new KyberPublicKeyParameters(this.kyberParams, keyPair[0], keyPair[1]);
        KyberPrivateKeyParameters privKey = new KyberPrivateKeyParameters(this.kyberParams, keyPair[2], keyPair[3], keyPair[4], keyPair[0], keyPair[1]);
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.initialize(param);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

