/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.AS2Endpoint;
import org.apache.camel.component.as2.api.AS2AsyncMDNServerConnection;
import org.apache.camel.component.as2.api.AS2AsyncMDNServerManager;
import org.apache.camel.component.as2.api.entity.DispositionNotificationMultipartReportEntity;
import org.apache.camel.component.as2.api.entity.EntityParser;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.component.as2.internal.AS2ApiName;
import org.apache.camel.support.component.AbstractApiConsumer;
import org.apache.camel.support.component.ApiConsumerHelper;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodHelper;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;

public class AS2AsyncMDNConsumer
extends AbstractApiConsumer<AS2ApiName, AS2Configuration>
implements HttpRequestHandler {
    private static final String HANDLER_PROPERTY = "handler";
    private final ApiMethod apiMethod;
    private final Map<String, Object> properties;
    private AS2AsyncMDNServerConnection as2ReceiptServerConnection;
    private AS2AsyncMDNServerManager apiProxy;

    public AS2AsyncMDNConsumer(AS2Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.apiMethod = ApiConsumerHelper.findMethod(endpoint, this);
        this.properties = new HashMap<String, Object>();
        this.properties.putAll(endpoint.getEndpointProperties());
        this.properties.put(HANDLER_PROPERTY, this);
    }

    @Override
    public void interceptPropertyNames(Set<String> propertyNames) {
        propertyNames.add(HANDLER_PROPERTY);
    }

    @Override
    protected int poll() throws Exception {
        return 0;
    }

    @Override
    public AS2Endpoint getEndpoint() {
        return (AS2Endpoint)super.getEndpoint();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.as2ReceiptServerConnection = this.getEndpoint().getAS2AsyncMDNServerConnection();
        this.apiProxy = new AS2AsyncMDNServerManager(this.as2ReceiptServerConnection);
        ApiMethodHelper.invokeMethod(this.apiProxy, this.apiMethod, this.properties);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException {
        Exception exception = null;
        try {
            HttpEntity entity;
            if (request instanceof HttpEntityContainer) {
                EntityParser.parseAS2MessageEntity(request);
            }
            if (!this.isValidReceiptEntity(entity = EntityUtils.getMessageEntity(request))) {
                String mimeType = ContentType.parse(entity.getContentType()).getMimeType();
                throw new HttpException("Received invalid receipt entity type: " + mimeType);
            }
            Exchange exchange = this.createExchange(false);
            try {
                HttpCoreContext coreContext = HttpCoreContext.adapt(context);
                exchange.setProperty("CamelAs2.interchange", (Object)coreContext);
                exchange.getIn().setBody(entity);
                this.getProcessor().process(exchange);
            }
            finally {
                exception = exchange.getException();
                this.releaseExchange(exchange, false);
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception != null) {
            throw new HttpException("Failed to process AS2 receipt: " + exception.getMessage(), exception);
        }
    }

    private boolean isValidReceiptEntity(HttpEntity entity) {
        if (entity instanceof MultipartSignedEntity) {
            MultipartSignedEntity multipartEntity = (MultipartSignedEntity)entity;
            entity = multipartEntity.getPart(0);
        }
        return entity instanceof DispositionNotificationMultipartReportEntity;
    }
}

