/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.IOException;
import java.net.Socket;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.camel.component.as2.api.io.AS2BHttpClientConnection;
import org.apache.camel.component.as2.api.protocol.RequestAS2;
import org.apache.camel.component.as2.api.protocol.RequestMDN;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.apache.hc.core5.http.protocol.RequestConnControl;
import org.apache.hc.core5.http.protocol.RequestContent;
import org.apache.hc.core5.http.protocol.RequestDate;
import org.apache.hc.core5.http.protocol.RequestExpectContinue;
import org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class AS2ClientConnection {
    private static final int RETRIEVE_CONNECTION_TIMEOUT_SECONDS = 5;
    private HttpHost targetHost;
    private HttpProcessor httpProcessor;
    private String as2Version;
    private String userAgent;
    private String clientFqdn;
    private int connectionTimeoutMilliseconds;
    private PoolingHttpClientConnectionManager connectionPoolManager;
    private ConnectionKeepAliveStrategy connectionKeepAliveStrategy;

    public AS2ClientConnection(String as2Version, String userAgent, String clientFqdn, String targetHostName, Integer targetPortNumber, Duration socketTimeout, Duration connectionTimeout, Integer connectionPoolMaxSize, Duration connectionPoolTtl, SSLContext sslContext, HostnameVerifier hostnameVerifier) throws IOException {
        this.as2Version = ObjectHelper.notNull(as2Version, "as2Version");
        this.userAgent = ObjectHelper.notNull(userAgent, "userAgent");
        this.clientFqdn = ObjectHelper.notNull(clientFqdn, "clientFqdn");
        this.targetHost = new HttpHost(sslContext != null ? "https" : "http", ObjectHelper.notNull(targetHostName, "targetHostName"), (int)ObjectHelper.notNull(targetPortNumber, "targetPortNumber"));
        ObjectHelper.notNull(socketTimeout, "socketTimeout");
        this.connectionTimeoutMilliseconds = (int)ObjectHelper.notNull(connectionTimeout, "connectionTimeout").toMillis();
        ObjectHelper.notNull(connectionPoolMaxSize, "connectionPoolMaxSize");
        ObjectHelper.notNull(connectionPoolTtl, "connectionPoolTtl");
        this.httpProcessor = HttpProcessorBuilder.create().add(new RequestAS2(as2Version, clientFqdn)).add(new RequestMDN()).add(new RequestTargetHost()).add(new RequestUserAgent(this.userAgent)).add(new RequestDate()).add(new RequestContent(true)).add(new RequestConnControl()).add(new RequestExpectContinue()).build();
        Http1Config h1Config = Http1Config.custom().setBufferSize(8192).build();
        ManagedHttpClientConnectionFactory connFactory = new ManagedHttpClientConnectionFactory(h1Config, null, null){

            @Override
            public ManagedHttpClientConnection createConnection(Socket socket) throws IOException {
                ManagedHttpClientConnection mc = super.createConnection(socket);
                return new AS2BHttpClientConnection(mc);
            }
        };
        if (sslContext == null) {
            this.connectionPoolManager = PoolingHttpClientConnectionManagerBuilder.create().setConnectionFactory(connFactory).build();
        } else {
            SSLConnectionSocketFactory sslConnectionSocketFactory = hostnameVerifier == null ? new SSLConnectionSocketFactory(sslContext) : new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
            Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslConnectionSocketFactory)).build();
            this.connectionPoolManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, connFactory);
        }
        this.connectionPoolManager.setMaxTotal(connectionPoolMaxSize);
        this.connectionPoolManager.setDefaultSocketConfig(SocketConfig.copy(SocketConfig.DEFAULT).setSoTimeout(Timeout.ofSeconds(socketTimeout.getSeconds())).build());
        this.connectionPoolManager.setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.ofMilliseconds(this.connectionTimeoutMilliseconds)).build());
        this.connectionKeepAliveStrategy = (response, context) -> {
            TimeValue ttl = TimeValue.of(connectionPoolTtl);
            for (Header h : response.getHeaders()) {
                HeaderElement headerElement;
                if ("Connection".equalsIgnoreCase(h.getName()) && "Close".equalsIgnoreCase(h.getValue())) {
                    ttl = TimeValue.NEG_ONE_MILLISECOND;
                }
                if (!"Keep-Alive".equalsIgnoreCase(h.getName()) || (headerElement = MessageSupport.parse(h)[0]).getValue() == null || !"timeout".equalsIgnoreCase(headerElement.getName())) continue;
                ttl = TimeValue.ofSeconds(Long.parseLong(headerElement.getValue()));
            }
            return ttl;
        };
        this.createTestConnection(sslContext, connFactory).close();
    }

    public String getAs2Version() {
        return this.as2Version;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getClientFqdn() {
        return this.clientFqdn;
    }

    public HttpResponse send(ClassicHttpRequest request, HttpCoreContext httpContext) throws HttpException, IOException, InterruptedException, ExecutionException, TimeoutException {
        HttpRoute route = new HttpRoute(this.targetHost);
        request.setAuthority(new URIAuthority(this.targetHost));
        LeaseRequest leaseRequest = this.connectionPoolManager.lease(UUID.randomUUID().toString(), route, null);
        ConnectionEndpoint endpoint = leaseRequest.get(Timeout.ofSeconds(5L));
        if (!endpoint.isConnected()) {
            this.connectionPoolManager.connect(endpoint, TimeValue.ofMilliseconds(this.connectionTimeoutMilliseconds), httpContext);
        }
        HttpRequestExecutor httpExecutor = new HttpRequestExecutor(){

            @Override
            public ClassicHttpResponse execute(ClassicHttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
                super.preProcess(request, AS2ClientConnection.this.httpProcessor, context);
                ClassicHttpResponse response = super.execute(request, conn, context);
                super.postProcess(response, AS2ClientConnection.this.httpProcessor, context);
                return response;
            }
        };
        ClassicHttpResponse response = endpoint.execute(UUID.randomUUID().toString(), request, httpExecutor, httpContext);
        this.connectionPoolManager.release(endpoint, null, this.connectionKeepAliveStrategy.getKeepAliveDuration(response, httpContext));
        return response;
    }

    private HttpConnection createTestConnection(SSLContext sslContext, HttpConnectionFactory<ManagedHttpClientConnection> connFactory) throws IOException {
        if (sslContext == null) {
            return connFactory.createConnection(new Socket(this.targetHost.getHostName(), this.targetHost.getPort()));
        }
        SSLSocketFactory factory = sslContext.getSocketFactory();
        return connFactory.createConnection(factory.createSocket(this.targetHost.getHostName(), this.targetHost.getPort()));
    }
}

