/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.component.as2.api.CanonicalOutputStream;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;

public class ApplicationPkcs7SignatureEntity
extends MimeEntity {
    private static final String CONTENT_DISPOSITION = "attachment; filename=\"smime.p7s\"";
    private static final String CONTENT_DESCRIPTION = "S/MIME Cryptographic Signature";
    private byte[] signature;

    public ApplicationPkcs7SignatureEntity(MimeEntity data, CMSSignedDataGenerator signer, String charset, String contentTransferEncoding, boolean isMainBody) throws HttpException {
        super(ContentType.parse(EntityUtils.appendParameter("application/pkcs7-signature; name=smime.p7s; smime-type=signed-data", "charset", charset)), contentTransferEncoding);
        ObjectHelper.notNull(data, "Data");
        ObjectHelper.notNull(signer, "Signer");
        this.addHeader("Content-Disposition", CONTENT_DISPOSITION);
        this.addHeader("Content-Description", CONTENT_DESCRIPTION);
        this.setMainBody(isMainBody);
        try {
            this.signature = this.createSignature(data, signer);
        }
        catch (Exception e) {
            throw new HttpException("Failed to create signed data", e);
        }
    }

    public ApplicationPkcs7SignatureEntity(byte[] signature, String charset, String contentTransferEncoding, boolean isMainBody) {
        super(ContentType.parse(EntityUtils.appendParameter("application/pkcs7-signature; name=smime.p7s; smime-type=signed-data", "charset", charset)), contentTransferEncoding);
        this.signature = ObjectHelper.notNull(signature, "signature");
        this.addHeader("Content-Disposition", CONTENT_DISPOSITION);
        this.addHeader("Content-Description", CONTENT_DESCRIPTION);
        this.setMainBody(isMainBody);
    }

    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        MimeEntity.NoCloseOutputStream ncos = new MimeEntity.NoCloseOutputStream(outstream);
        if (!this.isMainBody()) {
            try (CanonicalOutputStream canonicalOutstream = new CanonicalOutputStream(ncos, StandardCharsets.US_ASCII.name());){
                for (Header header : this.getAllHeaders()) {
                    canonicalOutstream.writeln(header.toString());
                }
                canonicalOutstream.writeln();
            }
        }
        String transferEncoding = this.getContentTransferEncoding() == null ? null : this.getContentTransferEncoding().getValue();
        try (OutputStream transferEncodedStream = EntityUtils.encode(ncos, transferEncoding);){
            transferEncodedStream.write(this.signature);
        }
        catch (Exception e) {
            throw new IOException("Failed to write to output stream", e);
        }
    }

    private byte[] createSignature(MimeEntity data, CMSSignedDataGenerator signer) throws IOException, CMSException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            data.writeTo(bos);
            bos.flush();
            CMSProcessableByteArray contentData = new CMSProcessableByteArray(bos.toByteArray());
            CMSSignedData signedData = signer.generate(contentData, false);
            byte[] byArray = signedData.getEncoded();
            return byArray;
        }
    }

    @Override
    public void close() throws IOException {
    }
}

