/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.ntru;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.pqc.legacy.crypto.ntru.NTRUSigningParameters;

public class NTRUSigningKeyGenerationParameters
extends KeyGenerationParameters
implements Cloneable {
    public static final int BASIS_TYPE_STANDARD = 0;
    public static final int BASIS_TYPE_TRANSPOSE = 1;
    public static final int KEY_GEN_ALG_RESULTANT = 0;
    public static final int KEY_GEN_ALG_FLOAT = 1;
    public static final NTRUSigningKeyGenerationParameters APR2011_439 = new NTRUSigningKeyGenerationParameters(439, 2048, 146, 1, 1, 0.165, 490.0, 280.0, false, true, 0, new SHA256Digest());
    public static final NTRUSigningKeyGenerationParameters APR2011_439_PROD = new NTRUSigningKeyGenerationParameters(439, 2048, 9, 8, 5, 1, 1, 0.165, 490.0, 280.0, false, true, 0, new SHA256Digest());
    public static final NTRUSigningKeyGenerationParameters APR2011_743 = new NTRUSigningKeyGenerationParameters(743, 2048, 248, 1, 1, 0.127, 560.0, 360.0, true, false, 0, new SHA512Digest());
    public static final NTRUSigningKeyGenerationParameters APR2011_743_PROD = new NTRUSigningKeyGenerationParameters(743, 2048, 11, 11, 15, 1, 1, 0.127, 560.0, 360.0, true, false, 0, new SHA512Digest());
    public static final NTRUSigningKeyGenerationParameters TEST157 = new NTRUSigningKeyGenerationParameters(157, 256, 29, 1, 1, 0.38, 200.0, 80.0, false, false, 0, new SHA256Digest());
    public static final NTRUSigningKeyGenerationParameters TEST157_PROD = new NTRUSigningKeyGenerationParameters(157, 256, 5, 5, 8, 1, 1, 0.38, 200.0, 80.0, false, false, 0, new SHA256Digest());
    public int N;
    public int q;
    public int d;
    public int d1;
    public int d2;
    public int d3;
    public int B;
    double beta;
    public double betaSq;
    double normBound;
    public double normBoundSq;
    public int signFailTolerance = 100;
    double keyNormBound;
    public double keyNormBoundSq;
    public boolean primeCheck;
    public int basisType;
    int bitsF = 6;
    public boolean sparse;
    public int keyGenAlg;
    public Digest hashAlg;
    public int polyType;

    public NTRUSigningKeyGenerationParameters(int N, int q, int d, int B, int basisType, double beta, double normBound, double keyNormBound, boolean primeCheck, boolean sparse, int keyGenAlg, Digest hashAlg) {
        super(CryptoServicesRegistrar.getSecureRandom(), N);
        this.N = N;
        this.q = q;
        this.d = d;
        this.B = B;
        this.basisType = basisType;
        this.beta = beta;
        this.normBound = normBound;
        this.keyNormBound = keyNormBound;
        this.primeCheck = primeCheck;
        this.sparse = sparse;
        this.keyGenAlg = keyGenAlg;
        this.hashAlg = hashAlg;
        this.polyType = 0;
        this.init();
    }

    public NTRUSigningKeyGenerationParameters(int N, int q, int d1, int d2, int d3, int B, int basisType, double beta, double normBound, double keyNormBound, boolean primeCheck, boolean sparse, int keyGenAlg, Digest hashAlg) {
        super(CryptoServicesRegistrar.getSecureRandom(), N);
        this.N = N;
        this.q = q;
        this.d1 = d1;
        this.d2 = d2;
        this.d3 = d3;
        this.B = B;
        this.basisType = basisType;
        this.beta = beta;
        this.normBound = normBound;
        this.keyNormBound = keyNormBound;
        this.primeCheck = primeCheck;
        this.sparse = sparse;
        this.keyGenAlg = keyGenAlg;
        this.hashAlg = hashAlg;
        this.polyType = 1;
        this.init();
    }

    private void init() {
        this.betaSq = this.beta * this.beta;
        this.normBoundSq = this.normBound * this.normBound;
        this.keyNormBoundSq = this.keyNormBound * this.keyNormBound;
    }

    public NTRUSigningKeyGenerationParameters(InputStream is) throws IOException {
        super(CryptoServicesRegistrar.getSecureRandom(), 0);
        DataInputStream dis = new DataInputStream(is);
        this.N = dis.readInt();
        this.q = dis.readInt();
        this.d = dis.readInt();
        this.d1 = dis.readInt();
        this.d2 = dis.readInt();
        this.d3 = dis.readInt();
        this.B = dis.readInt();
        this.basisType = dis.readInt();
        this.beta = dis.readDouble();
        this.normBound = dis.readDouble();
        this.keyNormBound = dis.readDouble();
        this.signFailTolerance = dis.readInt();
        this.primeCheck = dis.readBoolean();
        this.sparse = dis.readBoolean();
        this.bitsF = dis.readInt();
        this.keyGenAlg = dis.read();
        String alg = dis.readUTF();
        if ("SHA-512".equals(alg)) {
            this.hashAlg = new SHA512Digest();
        } else if ("SHA-256".equals(alg)) {
            this.hashAlg = new SHA256Digest();
        }
        this.polyType = dis.read();
        this.init();
    }

    public void writeTo(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeInt(this.N);
        dos.writeInt(this.q);
        dos.writeInt(this.d);
        dos.writeInt(this.d1);
        dos.writeInt(this.d2);
        dos.writeInt(this.d3);
        dos.writeInt(this.B);
        dos.writeInt(this.basisType);
        dos.writeDouble(this.beta);
        dos.writeDouble(this.normBound);
        dos.writeDouble(this.keyNormBound);
        dos.writeInt(this.signFailTolerance);
        dos.writeBoolean(this.primeCheck);
        dos.writeBoolean(this.sparse);
        dos.writeInt(this.bitsF);
        dos.write(this.keyGenAlg);
        dos.writeUTF(this.hashAlg.getAlgorithmName());
        dos.write(this.polyType);
    }

    public NTRUSigningParameters getSigningParameters() {
        return new NTRUSigningParameters(this.N, this.q, this.d, this.B, this.beta, this.normBound, this.hashAlg);
    }

    public NTRUSigningKeyGenerationParameters clone() {
        if (this.polyType == 0) {
            return new NTRUSigningKeyGenerationParameters(this.N, this.q, this.d, this.B, this.basisType, this.beta, this.normBound, this.keyNormBound, this.primeCheck, this.sparse, this.keyGenAlg, this.hashAlg);
        }
        return new NTRUSigningKeyGenerationParameters(this.N, this.q, this.d1, this.d2, this.d3, this.B, this.basisType, this.beta, this.normBound, this.keyNormBound, this.primeCheck, this.sparse, this.keyGenAlg, this.hashAlg);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.B;
        result = 31 * result + this.N;
        result = 31 * result + this.basisType;
        long temp = Double.doubleToLongBits(this.beta);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.betaSq);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.bitsF;
        result = 31 * result + this.d;
        result = 31 * result + this.d1;
        result = 31 * result + this.d2;
        result = 31 * result + this.d3;
        result = 31 * result + (this.hashAlg == null ? 0 : this.hashAlg.getAlgorithmName().hashCode());
        result = 31 * result + this.keyGenAlg;
        temp = Double.doubleToLongBits(this.keyNormBound);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.keyNormBoundSq);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.normBound);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.normBoundSq);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.polyType;
        result = 31 * result + (this.primeCheck ? 1231 : 1237);
        result = 31 * result + this.q;
        result = 31 * result + this.signFailTolerance;
        result = 31 * result + (this.sparse ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NTRUSigningKeyGenerationParameters)) {
            return false;
        }
        NTRUSigningKeyGenerationParameters other = (NTRUSigningKeyGenerationParameters)obj;
        if (this.B != other.B) {
            return false;
        }
        if (this.N != other.N) {
            return false;
        }
        if (this.basisType != other.basisType) {
            return false;
        }
        if (Double.doubleToLongBits(this.beta) != Double.doubleToLongBits(other.beta)) {
            return false;
        }
        if (Double.doubleToLongBits(this.betaSq) != Double.doubleToLongBits(other.betaSq)) {
            return false;
        }
        if (this.bitsF != other.bitsF) {
            return false;
        }
        if (this.d != other.d) {
            return false;
        }
        if (this.d1 != other.d1) {
            return false;
        }
        if (this.d2 != other.d2) {
            return false;
        }
        if (this.d3 != other.d3) {
            return false;
        }
        if (this.hashAlg == null ? other.hashAlg != null : !this.hashAlg.getAlgorithmName().equals(other.hashAlg.getAlgorithmName())) {
            return false;
        }
        if (this.keyGenAlg != other.keyGenAlg) {
            return false;
        }
        if (Double.doubleToLongBits(this.keyNormBound) != Double.doubleToLongBits(other.keyNormBound)) {
            return false;
        }
        if (Double.doubleToLongBits(this.keyNormBoundSq) != Double.doubleToLongBits(other.keyNormBoundSq)) {
            return false;
        }
        if (Double.doubleToLongBits(this.normBound) != Double.doubleToLongBits(other.normBound)) {
            return false;
        }
        if (Double.doubleToLongBits(this.normBoundSq) != Double.doubleToLongBits(other.normBoundSq)) {
            return false;
        }
        if (this.polyType != other.polyType) {
            return false;
        }
        if (this.primeCheck != other.primeCheck) {
            return false;
        }
        if (this.q != other.q) {
            return false;
        }
        if (this.signFailTolerance != other.signFailTolerance) {
            return false;
        }
        return this.sparse == other.sparse;
    }

    public String toString() {
        DecimalFormat format = new DecimalFormat("0.00");
        StringBuilder output = new StringBuilder("SignatureParameters(N=" + this.N + " q=" + this.q);
        if (this.polyType == 0) {
            output.append(" polyType=SIMPLE d=" + this.d);
        } else {
            output.append(" polyType=PRODUCT d1=" + this.d1 + " d2=" + this.d2 + " d3=" + this.d3);
        }
        output.append(" B=" + this.B + " basisType=" + this.basisType + " beta=" + format.format(this.beta) + " normBound=" + format.format(this.normBound) + " keyNormBound=" + format.format(this.keyNormBound) + " prime=" + this.primeCheck + " sparse=" + this.sparse + " keyGenAlg=" + this.keyGenAlg + " hashAlg=" + this.hashAlg + ")");
        return output.toString();
    }
}

