/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import org.apache.camel.Exchange;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.AS2Endpoint;
import org.apache.camel.component.as2.api.entity.DispositionNotificationMultipartReportEntity;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.internal.AS2ApiName;
import org.apache.camel.component.as2.internal.AS2PropertiesHelper;
import org.apache.camel.support.component.AbstractApiProducer;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpCoreContext;

public class AS2Producer
extends AbstractApiProducer<AS2ApiName, AS2Configuration> {
    public AS2Producer(AS2Endpoint endpoint) {
        super(endpoint, AS2PropertiesHelper.getHelper(endpoint.getCamelContext()));
    }

    @Override
    public void interceptResult(Object methodResult, Exchange resultExchange) {
        HttpCoreContext context = (HttpCoreContext)methodResult;
        resultExchange.setProperty("CamelAs2.interchange", (Object)context);
        HttpResponse response = context.getResponse();
        if (response instanceof ClassicHttpResponse) {
            ClassicHttpResponse classicResponse = (ClassicHttpResponse)response;
            HttpEntity entity = classicResponse.getEntity();
            if (entity instanceof DispositionNotificationMultipartReportEntity || entity instanceof MultipartSignedEntity) {
                resultExchange.getMessage().setBody(entity);
            } else {
                resultExchange.getMessage().setBody(null);
            }
        }
    }
}

