/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.asn1bean.ber.types;

import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.types.string.BerVisibleString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BerUtcTime
extends BerVisibleString {
    public static final BerTag tag = new BerTag(0, 0, 23);
    private static final long serialVersionUID = 1L;
    private static final String UTC_TIME_PATTERN = "^(?<year>\\d{2})(?<month>\\d{2})(?<day>\\d{2})(?<hour>\\d{2})(?<minute>\\d{2})(?<second>\\d{2})?(?<timezone>Z|([+-]\\d{4}))$";
    private static final Pattern utcTimePattern = Pattern.compile("^(?<year>\\d{2})(?<month>\\d{2})(?<day>\\d{2})(?<hour>\\d{2})(?<minute>\\d{2})(?<second>\\d{2})?(?<timezone>Z|([+-]\\d{4}))$");

    public BerUtcTime() {
    }

    public BerUtcTime(byte[] value) {
        this.value = value;
    }

    public BerUtcTime(String valueAsString) {
        super(valueAsString);
    }

    @Override
    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        int codeLength = super.encode(reverseOS, false);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        return codeLength += super.decode(is, false);
    }

    Calendar asCalendar() throws ParseException {
        Matcher matcher = utcTimePattern.matcher(this.toString());
        if (!matcher.find()) {
            throw new ParseException("", 0);
        }
        int year = Integer.parseInt(matcher.group("year"));
        int month = Integer.parseInt(matcher.group("month"));
        --month;
        int day = Integer.parseInt(matcher.group("day"));
        int hour = Integer.parseInt(matcher.group("hour"));
        int minute = Integer.parseInt(matcher.group("minute"));
        String mg = matcher.group("second");
        int second = mg == null ? 0 : Integer.parseInt(mg);
        mg = matcher.group("timezone");
        String timeZoneStr = mg.equals("Z") ? "UTC" : "GMT" + mg;
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneStr);
        Calendar calendar = Calendar.getInstance(timeZone);
        int century = calendar.get(1) / 100 * 100;
        calendar.set(year += century, month, day, hour, minute, second);
        calendar.set(14, 0);
        return calendar;
    }

    Date asDate() throws ParseException {
        return this.asCalendar().getTime();
    }
}

