/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import java.util.List;
import java.util.UUID;
import org.apache.camel.component.atmosphere.websocket.WebSocketStore;
import org.apache.camel.component.atmosphere.websocket.WebsocketConsumer;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketHandler
implements WebSocketProtocol {
    private static final transient Logger LOG = LoggerFactory.getLogger(WebsocketHandler.class);
    protected WebsocketConsumer consumer;
    protected WebSocketStore store;

    @Override
    public void configure(AtmosphereConfig config) {
    }

    @Override
    public void onClose(WebSocket webSocket) {
        LOG.debug("closing websocket");
        String connectionKey = this.store.getConnectionKey(webSocket);
        this.sendEventNotification(connectionKey, 0);
        this.store.removeWebSocket(webSocket);
        LOG.debug("websocket closed");
    }

    @Override
    public void onError(WebSocket webSocket, WebSocketProcessor.WebSocketException t) {
        LOG.error("websocket on error", (Throwable)t);
        String connectionKey = this.store.getConnectionKey(webSocket);
        this.sendEventNotification(connectionKey, -1);
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        LOG.debug("opening websocket");
        String connectionKey = UUID.randomUUID().toString();
        this.store.addWebSocket(connectionKey, webSocket);
        this.sendEventNotification(connectionKey, 1);
        LOG.debug("websocket opened");
    }

    @Override
    public List<AtmosphereRequest> onMessage(WebSocket webSocket, String data) {
        LOG.debug("processing text message {}", (Object)data);
        String connectionKey = this.store.getConnectionKey(webSocket);
        this.consumer.sendMessage(connectionKey, data);
        LOG.debug("text message sent");
        return null;
    }

    @Override
    public List<AtmosphereRequest> onMessage(WebSocket webSocket, byte[] data, int offset, int length) {
        LOG.debug("processing byte message {}", (Object)data);
        String connectionKey = this.store.getConnectionKey(webSocket);
        if (length < data.length) {
            byte[] rawdata = data;
            data = new byte[length];
            System.arraycopy(rawdata, offset, data, 0, length);
        }
        this.consumer.sendMessage(connectionKey, data);
        LOG.debug("byte message sent");
        return null;
    }

    public void setConsumer(WebsocketConsumer consumer) {
        this.consumer = consumer;
        this.store = consumer.getEndpoint().getWebSocketStore();
    }

    private void sendEventNotification(String connectionKey, int eventType) {
        if (this.consumer.isEnableEventsResending()) {
            this.consumer.sendEventNotification(connectionKey, eventType);
        }
    }
}

