/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.base64;

import org.apache.camel.spi.annotations.PropertiesFunction;
import org.apache.commons.codec.binary.Base64;

@PropertiesFunction(value="base64")
public class Base64PropertiesFunction
implements org.apache.camel.spi.PropertiesFunction {
    private final int lineLength = 76;
    private final byte[] lineSeparator = new byte[]{13, 10};
    private final Base64 codec = new Base64(76, this.lineSeparator, true);

    @Override
    public String getName() {
        return "base64";
    }

    @Override
    public boolean lookupFirst(String remainder) {
        return !remainder.startsWith("decode:");
    }

    @Override
    public String apply(String remainder) {
        if (remainder.startsWith("decode:")) {
            remainder = remainder.substring(7);
        }
        byte[] arr = this.codec.decode(remainder);
        return new String(arr);
    }
}

