/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.base64;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;

@Dataformat(value="base64")
public class Base64DataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private int lineLength = 76;
    private byte[] lineSeparator = new byte[]{13, 10};
    private boolean urlSafe;

    @Override
    public String getDataFormatName() {
        return "base64";
    }

    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        if (this.urlSafe) {
            this.marshalUrlSafe(exchange, graph, stream);
        } else {
            this.marshalStreaming(exchange, graph, stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshalStreaming(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        InputStream decoded = ExchangeHelper.convertToMandatoryType(exchange, InputStream.class, graph);
        Base64OutputStream base64Output = new Base64OutputStream(stream, true, this.lineLength, this.lineSeparator);
        try {
            IOHelper.copy(decoded, base64Output);
        }
        catch (Throwable throwable) {
            IOHelper.close(decoded, base64Output);
            throw throwable;
        }
        IOHelper.close(decoded, base64Output);
    }

    private void marshalUrlSafe(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        byte[] decoded = ExchangeHelper.convertToMandatoryType(exchange, byte[].class, graph);
        Base64 codec = new Base64(this.lineLength, this.lineSeparator, true);
        byte[] encoded = codec.encode(decoded);
        stream.write(encoded);
        stream.flush();
    }

    @Override
    public Object unmarshal(Exchange exchange, InputStream input) throws Exception {
        return new Base64InputStream(input, false, this.lineLength, this.lineSeparator);
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    public byte[] getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(byte[] lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public boolean isUrlSafe() {
        return this.urlSafe;
    }

    public void setUrlSafe(boolean urlSafe) {
        this.urlSafe = urlSafe;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

