/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bonita.api;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bonita.api.model.CaseCreationResponse;
import org.apache.camel.component.bonita.api.model.ProcessDefinitionResponse;
import org.apache.camel.component.bonita.api.util.BonitaAPIConfig;
import org.apache.camel.component.bonita.api.util.BonitaAPIUtil;
import org.apache.camel.util.ObjectHelper;

public class BonitaAPI {
    private BonitaAPIConfig bonitaApiConfig;
    private WebTarget webTarget;

    protected BonitaAPI(BonitaAPIConfig bonitaApiConfig, WebTarget webTarget) {
        this.bonitaApiConfig = bonitaApiConfig;
        this.webTarget = webTarget;
    }

    private WebTarget getBaseResource() {
        return this.webTarget;
    }

    public ProcessDefinitionResponse getProcessDefinition(String processName) {
        if (ObjectHelper.isEmpty(processName)) {
            throw new IllegalArgumentException("processName is empty.");
        }
        WebTarget resource = this.getBaseResource().path("process").queryParam("s", processName);
        List<ProcessDefinitionResponse> listProcess = resource.request().accept("application/json").get(new GenericType<List<ProcessDefinitionResponse>>(){});
        if (!listProcess.isEmpty()) {
            return listProcess.get(0);
        }
        throw new RuntimeCamelException("The process with name " + processName + " has not been retrieved");
    }

    public CaseCreationResponse startCase(ProcessDefinitionResponse processDefinition, Map<String, Serializable> rawInputs) throws Exception {
        if (processDefinition == null) {
            throw new IllegalArgumentException("ProcessDefinition is null");
        }
        if (rawInputs == null) {
            throw new IllegalArgumentException("The contract input is null");
        }
        Map<String, Serializable> inputs = BonitaAPIUtil.getInstance(this.bonitaApiConfig).prepareInputs(processDefinition, rawInputs);
        WebTarget resource = this.getBaseResource().path("process/{processId}/instantiation").resolveTemplate("processId", processDefinition.getId());
        return resource.request().accept("application/json").post(Entity.entity(inputs, "application/json"), CaseCreationResponse.class);
    }

    public BonitaAPIConfig getBonitaApiConfig() {
        return this.bonitaApiConfig;
    }

    public void setBonitaApiConfig(BonitaAPIConfig bonitaApiConfig) {
        this.bonitaApiConfig = bonitaApiConfig;
    }
}

