/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.bootstrap;

import jakarta.ws.rs.SeBootstrap;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import org.apache.cxf.jaxrs.bootstrap.ConfigurationImpl;

public class ConfigurationBuilderImpl
implements SeBootstrap.Configuration.Builder {
    private final Map<String, Map.Entry<Class<?>, Consumer<?>>> supported = new HashMap();
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public ConfigurationBuilderImpl() {
        this.supported.put("jakarta.ws.rs.SeBootstrap.Protocol", this.entry(String.class, this::protocol));
        this.supported.put("jakarta.ws.rs.SeBootstrap.Host", this.entry(String.class, this::host));
        this.supported.put("jakarta.ws.rs.SeBootstrap.Port", this.entry(Integer.class, this::port));
        this.supported.put("jakarta.ws.rs.SeBootstrap.RootPath", this.entry(String.class, this::rootPath));
        this.supported.put("jakarta.ws.rs.SeBootstrap.SSLContext", this.entry(SSLContext.class, this::sslContext));
        this.supported.put("jakarta.ws.rs.SeBootstrap.SSLClientAuthentication", this.entry(SeBootstrap.Configuration.SSLClientAuthentication.class, this::sslClientAuthentication));
    }

    private <T> AbstractMap.SimpleEntry<Class<?>, Consumer<?>> entry(Class<T> clazz, Consumer<T> consumer) {
        return new AbstractMap.SimpleEntry(clazz, consumer);
    }

    @Override
    public SeBootstrap.Configuration build() {
        return new ConfigurationImpl(this.properties);
    }

    @Override
    public SeBootstrap.Configuration.Builder property(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    @Override
    public <T> SeBootstrap.Configuration.Builder from(BiFunction<String, Class<T>, Optional<T>> propertiesProvider) {
        for (Map.Entry<String, Map.Entry<Class<?>, Consumer<?>>> entry : this.supported.entrySet()) {
            propertiesProvider.apply(entry.getKey(), entry.getValue().getKey()).ifPresent(entry.getValue().getValue());
        }
        return this;
    }

    @Override
    public SeBootstrap.Configuration.Builder from(Object externalConfig) {
        if (SeBootstrap.Configuration.class.isInstance(externalConfig)) {
            SeBootstrap.Configuration other = (SeBootstrap.Configuration)externalConfig;
            this.from((String name, Class<T> clazz) -> {
                Object property = other.property((String)name);
                if (property != null && clazz.equals(property.getClass())) {
                    return Optional.of(property);
                }
                return Optional.empty();
            });
        }
        return this;
    }
}

