/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bonita.api;

import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import org.apache.camel.component.bonita.api.BonitaAPI;
import org.apache.camel.component.bonita.api.filter.BonitaAuthFilter;
import org.apache.camel.component.bonita.api.util.BonitaAPIConfig;

public class BonitaAPIBuilder {
    protected BonitaAPIBuilder() {
    }

    public static BonitaAPI build(BonitaAPIConfig bonitaAPIConfig) {
        if (bonitaAPIConfig == null) {
            throw new IllegalArgumentException("bonitaApiConfig is null");
        }
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        clientBuilder.register(JacksonJsonProvider.class);
        Client client = clientBuilder.build();
        client.register(new BonitaAuthFilter(bonitaAPIConfig));
        WebTarget webTarget = client.target(bonitaAPIConfig.getBaseBonitaURI()).path("/API/bpm");
        return new BonitaAPI(bonitaAPIConfig, webTarget);
    }
}

