/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bonita.api.filter;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.component.bonita.api.util.BonitaAPIConfig;
import org.apache.camel.util.ObjectHelper;

public class BonitaAuthFilter
implements ClientRequestFilter {
    private BonitaAPIConfig bonitaApiConfig;

    public BonitaAuthFilter(BonitaAPIConfig bonitaApiConfig) {
        this.bonitaApiConfig = bonitaApiConfig;
    }

    @Override
    public void filter(ClientRequestContext requestContext) throws IOException {
        if (requestContext.getCookies().get("JSESSIONID") == null) {
            String username = this.bonitaApiConfig.getUsername();
            String password = this.bonitaApiConfig.getPassword();
            String bonitaApiToken = null;
            if (ObjectHelper.isEmpty(username)) {
                throw new IllegalArgumentException("Username provided is null or empty.");
            }
            if (ObjectHelper.isEmpty(password)) {
                throw new IllegalArgumentException("Password provided is null or empty.");
            }
            ClientBuilder clientBuilder = ClientBuilder.newBuilder();
            Client client = clientBuilder.build();
            WebTarget webTarget = client.target(this.bonitaApiConfig.getBaseBonitaURI()).path("loginservice");
            MultivaluedHashMap<String, String> form = new MultivaluedHashMap<String, String>();
            form.add("username", username);
            form.add("password", password);
            form.add("redirect", "false");
            Response response = webTarget.request().accept("application/x-www-form-urlencoded").post(Entity.form(form));
            Map<String, NewCookie> cr = response.getCookies();
            ArrayList<String> cookies = new ArrayList<String>();
            for (NewCookie cookie : cr.values()) {
                if ("X-Bonita-API-Token".equals(cookie.getName())) {
                    bonitaApiToken = cookie.getValue();
                    requestContext.getHeaders().add("X-Bonita-API-Token", bonitaApiToken);
                }
                cookies.add(cookie.toString());
            }
            requestContext.getHeaders().put("Cookie", cookies);
        }
    }

    public BonitaAPIConfig getBonitaApiConfig() {
        return this.bonitaApiConfig;
    }

    public void setBonitaApiConfig(BonitaAPIConfig bonitaApiConfig) {
        this.bonitaApiConfig = bonitaApiConfig;
    }
}

