/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxJSONObject;
import com.box.sdk.BoxWebLink;
import com.box.sdk.Metadata;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class BoxMetadataQueryItem
extends BoxJSONObject {
    private BoxItem.Info item;
    private HashMap<String, ArrayList<Metadata>> metadata;
    private BoxAPIConnection api;

    public BoxMetadataQueryItem(JsonObject jsonObject, BoxAPIConnection api) {
        super(jsonObject);
        this.api = api;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        super.parseJSONMember(member);
        String memberName = member.getName();
        JsonValue value = member.getValue();
        if (memberName.equals("item")) {
            String id = value.asObject().get("id").asString();
            String type = value.asObject().get("type").asString();
            BoxFile boxFile = new BoxFile(this.api, id);
            boxFile.getClass();
            this.item = boxFile.new BoxFile.Info(value.asObject());
            if (type.equals("folder")) {
                BoxFolder folder;
                BoxFolder boxFolder = folder = new BoxFolder(this.api, id);
                boxFolder.getClass();
                this.item = boxFolder.new BoxFolder.Info(value.asObject());
                return;
            }
            if (type.equals("file")) {
                BoxFile file;
                BoxFile boxFile2 = file = new BoxFile(this.api, id);
                boxFile2.getClass();
                this.item = boxFile2.new BoxFile.Info(value.asObject());
                return;
            }
            if (type.equals("web_link")) {
                BoxWebLink link;
                BoxWebLink boxWebLink = link = new BoxWebLink(this.api, id);
                boxWebLink.getClass();
                this.item = boxWebLink.new BoxWebLink.Info(value.asObject());
                return;
            }
            if ($assertionsDisabled) throw new BoxAPIException("Unsupported item type: " + type);
            throw new AssertionError((Object)("Unsupported item type: " + type));
        }
        if (!memberName.equals("metadata")) return;
        this.metadata = new HashMap();
        JsonObject metadataObject = value.asObject();
        Iterator<JsonObject.Member> iterator2 = metadataObject.iterator();
        while (iterator2.hasNext()) {
            JsonObject.Member enterprise = iterator2.next();
            String enterpriseName = enterprise.getName();
            JsonObject templates = enterprise.getValue().asObject();
            ArrayList<Metadata> enterpriseMetadataArray = new ArrayList<Metadata>();
            for (JsonObject.Member template : templates) {
                String templateName = template.getName();
                JsonObject templateValue = template.getValue().asObject();
                Metadata metadataOfTemplate = new Metadata(templateValue);
                metadataOfTemplate.add("/$scope", enterpriseName);
                metadataOfTemplate.add("/$template", templateName);
                enterpriseMetadataArray.add(metadataOfTemplate);
            }
            this.metadata.put(enterpriseName, enterpriseMetadataArray);
        }
    }

    public BoxItem.Info getItem() {
        return this.item;
    }

    public HashMap<String, ArrayList<Metadata>> getMetadata() {
        return this.metadata;
    }
}

