/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxSearchParameters;
import com.box.sdk.BoxSearchSharedLink;
import com.box.sdk.PartialCollection;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;

public class BoxSearch {
    public static final URLTemplate SEARCH_URL_TEMPLATE = new URLTemplate("search");
    private final BoxAPIConnection api;

    public BoxSearch(BoxAPIConnection api) {
        this.api = api;
    }

    public PartialCollection<BoxItem.Info> searchRange(long offset, long limit, BoxSearchParameters bsp) {
        QueryStringBuilder builder = bsp.getQueryParameters().appendParam("limit", limit).appendParam("offset", offset);
        URL url = SEARCH_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "GET");
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
            String totalCountString = responseJSON.get("total_count").toString();
            long fullSize = Double.valueOf(totalCountString).longValue();
            PartialCollection<BoxItem.Info> results = new PartialCollection<BoxItem.Info>(offset, limit, fullSize);
            JsonArray jsonArray = responseJSON.get("entries").asArray();
            for (JsonValue value : jsonArray) {
                JsonObject jsonObject = value.asObject();
                BoxItem.Info parsedItemInfo = (BoxItem.Info)BoxResource.parseInfo(this.getAPI(), jsonObject);
                if (parsedItemInfo == null) continue;
                results.add(parsedItemInfo);
            }
            PartialCollection<BoxItem.Info> partialCollection = results;
            return partialCollection;
        }
    }

    public PartialCollection<BoxSearchSharedLink> searchRangeIncludeSharedLinks(long offset, long limit, BoxSearchParameters bsp) {
        QueryStringBuilder builder = bsp.getQueryParameters().appendParam("include_recent_shared_links", "true").appendParam("limit", limit).appendParam("offset", offset);
        URL url = SEARCH_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "GET");
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
            String totalCountString = responseJSON.get("total_count").toString();
            long fullSize = Double.valueOf(totalCountString).longValue();
            PartialCollection<BoxSearchSharedLink> results = new PartialCollection<BoxSearchSharedLink>(offset, limit, fullSize);
            JsonArray jsonArray = responseJSON.get("entries").asArray();
            for (JsonValue value : jsonArray) {
                JsonObject jsonObject = value.asObject();
                BoxSearchSharedLink parsedItem = new BoxSearchSharedLink(jsonObject, this.getAPI());
                results.add(parsedItem);
            }
            PartialCollection<BoxSearchSharedLink> partialCollection = results;
            return partialCollection;
        }
    }

    public BoxAPIConnection getAPI() {
        return this.api;
    }
}

