/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxCollaboration;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxFolder;
import java.util.Collection;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.box.api.BoxHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxCollaborationsManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxCollaborationsManager.class);
    private BoxAPIConnection boxConnection;

    public BoxCollaborationsManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public Collection<BoxCollaboration.Info> getFolderCollaborations(String folderId) {
        try {
            LOG.debug("Getting collaborations for folder(id={})", (Object)folderId);
            BoxHelper.notNull(folderId, "folderId");
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            return folder.getCollaborations(new String[0]);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public BoxCollaboration addFolderCollaboration(String folderId, BoxCollaborator collaborator, BoxCollaboration.Role role) {
        try {
            BoxHelper.notNull(folderId, "folderId");
            BoxHelper.notNull(collaborator, "collaborator");
            LOG.debug("Creating  collaborations for folder(id={}) with collaborator({})", (Object)folderId, (Object)collaborator.getID());
            BoxHelper.notNull(role, "role");
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            return folder.collaborate(collaborator, role).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public BoxCollaboration addFolderCollaborationByEmail(String folderId, String email, BoxCollaboration.Role role) {
        try {
            LOG.debug("Creating  collaborations for folder(id={}) with collaborator({})", (Object)folderId, (Object)email);
            BoxHelper.notNull(folderId, "folderId");
            BoxHelper.notNull(email, "email");
            BoxHelper.notNull(role, "role");
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            return folder.collaborate(email, role).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public BoxCollaboration.Info getCollaborationInfo(String collaborationId) {
        try {
            LOG.debug("Getting info for collaboration(id={})", (Object)collaborationId);
            BoxHelper.notNull(collaborationId, "collaborationId");
            BoxCollaboration collaboration = new BoxCollaboration(this.boxConnection, collaborationId);
            return collaboration.getInfo(new String[0]);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public BoxCollaboration updateCollaborationInfo(String collaborationId, BoxCollaboration.Info info) {
        try {
            LOG.debug("Updating info for collaboration(id={})", (Object)collaborationId);
            BoxHelper.notNull(collaborationId, "collaborationId");
            BoxCollaboration collaboration = new BoxCollaboration(this.boxConnection, collaborationId);
            collaboration.updateInfo(info);
            return collaboration;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public void deleteCollaboration(String collaborationId) {
        try {
            LOG.debug("Deleting collaboration(id={})", (Object)collaborationId);
            BoxHelper.notNull(collaborationId, "collaborationId");
            BoxCollaboration collaboration = new BoxCollaboration(this.boxConnection, collaborationId);
            collaboration.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public Collection<BoxCollaboration.Info> getPendingCollaborations() {
        try {
            return BoxCollaboration.getPendingCollaborations(this.boxConnection, new String[0]);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }
}

