/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAIDialogueEntry;
import com.box.sdk.BoxAIItem;
import com.box.sdk.BoxAIResponse;
import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.URLTemplate;
import com.box.sdk.http.HttpMethod;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import java.net.URL;
import java.util.List;

public final class BoxAI {
    public static final URLTemplate SEND_AI_REQUEST_URL = new URLTemplate("ai/ask");
    public static final URLTemplate SEND_AI_TEXT_GEN_REQUEST_URL = new URLTemplate("ai/text_gen");

    private BoxAI() {
    }

    public static BoxAIResponse sendAIRequest(BoxAPIConnection api, String prompt, List<BoxAIItem> items, Mode mode) {
        URL url = SEND_AI_REQUEST_URL.build(api.getBaseURL(), new Object[0]);
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("mode", mode.toString());
        requestJSON.add("prompt", prompt);
        JsonArray itemsJSON = new JsonArray();
        for (BoxAIItem item : items) {
            itemsJSON.add(item.getJSONObject());
        }
        requestJSON.add("items", itemsJSON);
        BoxJSONRequest req = new BoxJSONRequest(api, url, HttpMethod.POST);
        req.setBody(requestJSON.toString());
        try (BoxJSONResponse response = req.send();){
            JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
            BoxAIResponse boxAIResponse = new BoxAIResponse(responseJSON);
            return boxAIResponse;
        }
    }

    public static BoxAIResponse sendAITextGenRequest(BoxAPIConnection api, String prompt, List<BoxAIItem> items) {
        return BoxAI.sendAITextGenRequest(api, prompt, items, null);
    }

    public static BoxAIResponse sendAITextGenRequest(BoxAPIConnection api, String prompt, List<BoxAIItem> items, List<BoxAIDialogueEntry> dialogueHistory) {
        URL url = SEND_AI_TEXT_GEN_REQUEST_URL.build(api.getBaseURL(), new Object[0]);
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("prompt", prompt);
        JsonArray itemsJSON = new JsonArray();
        for (BoxAIItem boxAIItem : items) {
            itemsJSON.add(boxAIItem.getJSONObject());
        }
        requestJSON.add("items", itemsJSON);
        if (dialogueHistory != null) {
            JsonArray dialogueHistoryJSON = new JsonArray();
            for (BoxAIDialogueEntry dialogueEntry : dialogueHistory) {
                dialogueHistoryJSON.add(dialogueEntry.getJSONObject());
            }
            requestJSON.add("dialogue_history", dialogueHistoryJSON);
        }
        BoxJSONRequest req = new BoxJSONRequest(api, url, HttpMethod.POST);
        req.setBody(requestJSON.toString());
        try (BoxJSONResponse boxJSONResponse = req.send();){
            JsonObject responseJSON = Json.parse(boxJSONResponse.getJSON()).asObject();
            BoxAIResponse boxAIResponse = new BoxAIResponse(responseJSON);
            return boxAIResponse;
        }
    }

    public static enum Mode {
        MULTIPLE_ITEM_QA("multiple_item_qa"),
        SINGLE_ITEM_QA("single_item_qa");

        private final String mode;

        private Mode(String mode) {
            this.mode = mode;
        }

        static Mode fromJSONValue(String jsonValue) {
            if (jsonValue.equals("multiple_item_qa")) {
                return MULTIPLE_ITEM_QA;
            }
            if (jsonValue.equals("single_item_qa")) {
                return SINGLE_ITEM_QA;
            }
            System.out.print("Invalid AI mode.");
            return null;
        }

        String toJSONValue() {
            return this.mode;
        }

        public String toString() {
            return this.mode;
        }
    }
}

