/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxJSONObject;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Date;

public class BoxSharedLink
extends BoxJSONObject {
    private String url;
    private String downloadUrl;
    private String vanityUrl;
    private String vanityName;
    private boolean isPasswordEnabled;
    private String password;
    private Date unsharedAt;
    private long downloadCount;
    private long previewCount;
    private Access access;
    private Access effectiveAccess;
    private Permissions permissions;

    public BoxSharedLink() {
    }

    public BoxSharedLink(String json) {
        super(json);
    }

    BoxSharedLink(JsonObject jsonObject) {
        super(jsonObject);
    }

    BoxSharedLink(Access access, Date unshareDate, Permissions permissions) {
        this.setAccess(access);
        this.setPermissions(permissions);
        if (unshareDate != null) {
            this.setUnsharedDate(unshareDate);
        }
    }

    BoxSharedLink(Access access, Date unshareDate, Permissions permissions, String password) {
        this.setAccess(access);
        this.setPermissions(permissions);
        this.setPassword(password);
        if (unshareDate != null) {
            this.setUnsharedDate(unshareDate);
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getDownloadURL() {
        return this.downloadUrl;
    }

    public String getVanityURL() {
        return this.vanityUrl;
    }

    public String getVanityName() {
        return this.vanityName;
    }

    public void setVanityName(String vanityName) {
        if (vanityName != null && vanityName.length() < 12) {
            throw new IllegalArgumentException("The vanityName has to be at least 12 characters long.");
        }
        this.vanityName = vanityName;
        this.addPendingChange("vanity_name", vanityName);
    }

    public boolean getIsPasswordEnabled() {
        return this.isPasswordEnabled;
    }

    public Date getUnsharedDate() {
        return this.unsharedAt;
    }

    public void setUnsharedDate(Date unsharedDate) {
        this.unsharedAt = unsharedDate;
        this.addPendingChange("unshared_at", BoxDateFormat.format(unsharedDate));
    }

    public long getDownloadCount() {
        return this.downloadCount;
    }

    public long getPreviewCount() {
        return this.previewCount;
    }

    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
        this.addPendingChange("access", access.toJSONValue());
    }

    public void setPassword(String password) {
        this.password = password;
        this.addPendingChange("password", password);
    }

    public Access getEffectiveAccess() {
        return this.effectiveAccess;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        if (this.permissions != null && this.permissions.equals(permissions)) {
            return;
        }
        this.removeChildObject("permissions");
        this.permissions = permissions;
        this.addChildObject("permissions", permissions);
    }

    private Access parseAccessValue(JsonValue value) {
        String accessString = value.asString().toUpperCase();
        return Access.valueOf(accessString);
    }

    @Override
    protected JsonObject getPendingJSONObject() {
        JsonObject result = super.getPendingJSONObject();
        if (result == null) {
            result = new JsonObject();
        }
        return result;
    }

    @Override
    void parseJSONMember(JsonObject.Member member) {
        JsonValue value = member.getValue();
        String memberName = member.getName();
        try {
            if (memberName.equals("url")) {
                this.url = value.asString();
            } else if (memberName.equals("download_url")) {
                this.downloadUrl = value.asString();
            } else if (memberName.equals("vanity_url")) {
                this.vanityUrl = value.asString();
            } else if (memberName.equals("vanity_name")) {
                this.vanityName = value.asString();
            } else if (memberName.equals("is_password_enabled")) {
                this.isPasswordEnabled = value.asBoolean();
            } else if (memberName.equals("unshared_at")) {
                this.unsharedAt = BoxDateFormat.parse(value.asString());
            } else if (memberName.equals("download_count")) {
                this.downloadCount = Double.valueOf(value.toString()).longValue();
            } else if (memberName.equals("preview_count")) {
                this.previewCount = Double.valueOf(value.toString()).longValue();
            } else if (memberName.equals("access")) {
                this.access = this.parseAccessValue(value);
            } else if (memberName.equals("effective_access")) {
                this.effectiveAccess = this.parseAccessValue(value);
            } else if (memberName.equals("permissions")) {
                if (this.permissions == null) {
                    this.setPermissions(new Permissions(value.asObject()));
                } else {
                    this.permissions.update(value.asObject());
                }
            }
        }
        catch (Exception e) {
            throw new BoxDeserializationException(memberName, value.toString(), e);
        }
    }

    public static String getSharedLinkHeaderValue(String sharedLink, String password) {
        String boxAPIValue = "shared_link=" + sharedLink;
        if (password != null) {
            boxAPIValue = boxAPIValue + "&shared_link_password=" + password;
        }
        return boxAPIValue;
    }

    public static class Permissions
    extends BoxJSONObject {
        private boolean canDownload;
        private boolean canPreview;
        private boolean canEdit;

        public Permissions() {
        }

        Permissions(boolean canPreview, boolean canDownload, boolean canEdit) {
            this.setCanPreview(canPreview);
            this.setCanDownload(canDownload);
            this.setCanEdit(canEdit);
        }

        public Permissions(String json) {
            super(json);
        }

        Permissions(JsonObject jsonObject) {
            super(jsonObject);
        }

        public boolean getCanDownload() {
            return this.canDownload;
        }

        public void setCanDownload(boolean enabled) {
            this.canDownload = enabled;
            this.addPendingChange("can_download", enabled);
        }

        public boolean getCanPreview() {
            return this.canPreview;
        }

        public void setCanPreview(boolean enabled) {
            this.canPreview = enabled;
            this.addPendingChange("can_preview", enabled);
        }

        public boolean getCanEdit() {
            return this.canEdit;
        }

        public void setCanEdit(boolean enabled) {
            this.canEdit = enabled;
            this.addPendingChange("can_edit", enabled);
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if (memberName.equals("can_download")) {
                this.canDownload = value.asBoolean();
            }
            if (memberName.equals("can_preview")) {
                this.canPreview = value.asBoolean();
            }
            if (memberName.equals("can_edit")) {
                this.canEdit = value.asBoolean();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Permissions that = (Permissions)o;
            return this.canDownload == that.canDownload && this.canPreview == that.canPreview && this.canEdit == that.canEdit;
        }

        public int hashCode() {
            int result = this.canDownload ? 1 : 0;
            result = 31 * result + (this.canPreview ? 1 : 0);
            result = 31 * result + (this.canEdit ? 1 : 0);
            return result;
        }

        public String toString() {
            return "Permissions{canDownload=" + this.canDownload + ", canPreview=" + this.canPreview + ", canEdit=" + this.canEdit + '}';
        }
    }

    public static enum Access {
        DEFAULT(null),
        OPEN("open"),
        COMPANY("company"),
        COLLABORATORS("collaborators");

        private final String jsonValue;

        private Access(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }
}

