/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxSignRequestCreateParams;
import com.box.sdk.BoxSignRequestFile;
import com.box.sdk.BoxSignRequestPrefillTag;
import com.box.sdk.BoxSignRequestSignatureColor;
import com.box.sdk.BoxSignRequestSigner;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@BoxResourceType(value="sign_request")
public class BoxSignRequest
extends BoxResource {
    public static final URLTemplate SIGN_REQUESTS_URL_TEMPLATE = new URLTemplate("sign_requests");
    public static final URLTemplate SIGN_REQUEST_URL_TEMPLATE = new URLTemplate("sign_requests/%s");
    public static final URLTemplate SIGN_REQUEST_CANCEL_URL_TEMPLATE = new URLTemplate("sign_requests/%s/cancel");
    public static final URLTemplate SIGN_REQUEST_RESEND_URL_TEMPLATE = new URLTemplate("sign_requests/%s/resend");
    private static final int DEFAULT_LIMIT = 100;

    public BoxSignRequest(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info createSignRequestFromFiles(BoxAPIConnection api, List<BoxFile.Info> sourceFiles, List<BoxSignRequestSigner> signers, String parentFolderId, BoxSignRequestCreateParams optionalParams) {
        return BoxSignRequest.createSignRequest(api, BoxSignRequest.toBoxSignRequestFiles(sourceFiles), signers, parentFolderId, optionalParams);
    }

    public static Info createSignRequestFromFiles(BoxAPIConnection api, List<BoxFile.Info> sourceFiles, List<BoxSignRequestSigner> signers, String parentFolderId) {
        return BoxSignRequest.createSignRequest(api, BoxSignRequest.toBoxSignRequestFiles(sourceFiles), signers, parentFolderId, null);
    }

    public static Info createSignRequest(BoxAPIConnection api, List<BoxSignRequestFile> sourceFiles, List<BoxSignRequestSigner> signers, String parentFolderId) {
        return BoxSignRequest.createSignRequest(api, sourceFiles, signers, parentFolderId, null);
    }

    public static Info createSignRequest(BoxAPIConnection api, List<BoxSignRequestFile> sourceFiles, List<BoxSignRequestSigner> signers, String parentFolderId, BoxSignRequestCreateParams optionalParams) {
        JsonObject requestJSON = new JsonObject();
        JsonArray sourceFilesJSON = new JsonArray();
        for (BoxSignRequestFile boxSignRequestFile : sourceFiles) {
            sourceFilesJSON.add(boxSignRequestFile.getJSONObject());
        }
        requestJSON.add("source_files", sourceFilesJSON);
        JsonArray signersJSON = new JsonArray();
        for (BoxSignRequestSigner signer : signers) {
            signersJSON.add(signer.getJSONObject());
        }
        requestJSON.add("signers", signersJSON);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("id", parentFolderId);
        jsonObject.add("type", "folder");
        requestJSON.add("parent_folder", jsonObject);
        if (optionalParams != null) {
            optionalParams.appendParamsAsJson(requestJSON);
        }
        URL url = SIGN_REQUESTS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        try (BoxJSONResponse response = request.send();){
            BoxSignRequest signRequest;
            JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
            BoxSignRequest boxSignRequest = signRequest = new BoxSignRequest(api, responseJSON.get("id").asString());
            boxSignRequest.getClass();
            Info info = boxSignRequest.new Info(responseJSON);
            return info;
        }
    }

    public static Iterable<Info> getAll(BoxAPIConnection api, String ... fields) {
        return BoxSignRequest.getAll(api, 100, fields);
    }

    public static Iterable<Info> getAll(final BoxAPIConnection api, int limit, String ... fields) {
        QueryStringBuilder queryString = new QueryStringBuilder();
        if (fields.length > 0) {
            queryString.appendParam("fields", fields);
        }
        URL url = SIGN_REQUESTS_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), queryString.toString(), new Object[0]);
        return new BoxResourceIterable<Info>(api, url, limit){

            @Override
            protected Info factory(JsonObject jsonObject) {
                BoxSignRequest signRequest;
                BoxSignRequest boxSignRequest = signRequest = new BoxSignRequest(api, jsonObject.get("id").asString());
                boxSignRequest.getClass();
                return boxSignRequest.new Info(jsonObject);
            }
        };
    }

    private static List<BoxSignRequestFile> toBoxSignRequestFiles(List<BoxFile.Info> sourceFiles) {
        ArrayList<BoxSignRequestFile> files = new ArrayList<BoxSignRequestFile>();
        for (BoxFile.Info sourceFile : sourceFiles) {
            BoxSignRequestFile file = BoxSignRequestFile.fromFile(sourceFile);
            files.add(file);
        }
        return files;
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = SIGN_REQUEST_URL_TEMPLATE.buildAlphaWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "GET");
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
            Info info = new Info(responseJSON);
            return info;
        }
    }

    public Info cancel() {
        URL url = SIGN_REQUEST_CANCEL_URL_TEMPLATE.buildAlphaWithQuery(this.getAPI().getBaseURL(), "", this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
            Info info = new Info(responseJSON);
            return info;
        }
    }

    public void resend() {
        URL url = SIGN_REQUEST_RESEND_URL_TEMPLATE.buildAlphaWithQuery(this.getAPI().getBaseURL(), "", this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "POST");
        request.send().close();
    }

    public class Info
    extends BoxResource.Info {
        private boolean isDocumentPreparationNeeded;
        private boolean areTextSignaturesEnabled;
        private boolean areDatesEnabled;
        private BoxSignRequestSignatureColor signatureColor;
        private String emailSubject;
        private String emailMessage;
        private boolean areRemindersEnabled;
        private List<BoxFile.Info> sourceFiles;
        private BoxFolder.Info parentFolder;
        private List<BoxSignRequestSigner> signers;
        private String name;
        private List<BoxSignRequestPrefillTag> prefillTags;
        private Integer daysValid;
        private String externalId;
        private String prepareUrl;
        private BoxFile.Info signingLog;
        private BoxSignRequestStatus status;
        private BoxSignRequestSignFiles signFiles;
        private Date autoExpireAt;
        private String redirectUrl;
        private String declinedRedirectUrl;
        private String templateId;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        public boolean getIsDocumentPreparationNeeded() {
            return this.isDocumentPreparationNeeded;
        }

        public boolean getAreTextSignaturesEnabled() {
            return this.areTextSignaturesEnabled;
        }

        public boolean getAreDatesEnabled() {
            return this.areDatesEnabled;
        }

        public BoxSignRequestSignatureColor getSignatureColor() {
            return this.signatureColor;
        }

        public String getEmailSubject() {
            return this.emailSubject;
        }

        public String getEmailMessage() {
            return this.emailMessage;
        }

        public boolean getAreRemindersEnabled() {
            return this.areRemindersEnabled;
        }

        public List<BoxFile.Info> getSourceFiles() {
            return this.sourceFiles;
        }

        public BoxFolder.Info getParentFolder() {
            return this.parentFolder;
        }

        public List<BoxSignRequestSigner> getSigners() {
            return this.signers;
        }

        public String getName() {
            return this.name;
        }

        public List<BoxSignRequestPrefillTag> getPrefillTags() {
            return this.prefillTags;
        }

        public Integer getDaysValid() {
            return this.daysValid;
        }

        public String getExternalId() {
            return this.externalId;
        }

        public String getPrepareUrl() {
            return this.prepareUrl;
        }

        public BoxFile.Info getSigningLog() {
            return this.signingLog;
        }

        public BoxSignRequestStatus getStatus() {
            return this.status;
        }

        public BoxSignRequestSignFiles getSignFiles() {
            return this.signFiles;
        }

        public Date getAutoExpireAt() {
            return this.autoExpireAt;
        }

        public String getRedirectUrl() {
            return this.redirectUrl;
        }

        public String getDeclinedRedirectUrl() {
            return this.declinedRedirectUrl;
        }

        public String getTemplateId() {
            return this.templateId;
        }

        @Override
        public BoxSignRequest getResource() {
            return BoxSignRequest.this;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                switch (memberName) {
                    case "is_document_preparation_needed": {
                        this.isDocumentPreparationNeeded = value.asBoolean();
                        break;
                    }
                    case "are_text_signatures_enabled": {
                        this.areTextSignaturesEnabled = value.asBoolean();
                        break;
                    }
                    case "are_dates_enabled": {
                        this.areDatesEnabled = value.asBoolean();
                        break;
                    }
                    case "signature_color": {
                        this.signatureColor = BoxSignRequestSignatureColor.fromJSONString(value.asString());
                        break;
                    }
                    case "email_subject": {
                        this.emailSubject = value.asString();
                        break;
                    }
                    case "email_message": {
                        this.emailMessage = value.asString();
                        break;
                    }
                    case "are_reminders_enabled": {
                        this.areRemindersEnabled = value.asBoolean();
                        break;
                    }
                    case "signers": {
                        ArrayList<BoxSignRequestSigner> signers = new ArrayList<BoxSignRequestSigner>();
                        for (JsonValue signerJSON : value.asArray()) {
                            BoxSignRequestSigner signer = new BoxSignRequestSigner(signerJSON.asObject(), BoxSignRequest.this.getAPI());
                            signers.add(signer);
                        }
                        this.signers = signers;
                        break;
                    }
                    case "source_files": {
                        this.sourceFiles = this.getFiles(value.asArray());
                        break;
                    }
                    case "parent_folder": {
                        BoxFolder folder;
                        JsonObject folderJSON = value.asObject();
                        String folderID = folderJSON.get("id").asString();
                        BoxFolder boxFolder = folder = new BoxFolder(BoxSignRequest.this.getAPI(), folderID);
                        boxFolder.getClass();
                        this.parentFolder = boxFolder.new BoxFolder.Info(folderJSON);
                        break;
                    }
                    case "name": {
                        this.name = value.asString();
                        break;
                    }
                    case "prefill_tags": {
                        ArrayList<BoxSignRequestPrefillTag> prefillTags = new ArrayList<BoxSignRequestPrefillTag>();
                        for (JsonValue prefillTagJSON : value.asArray()) {
                            BoxSignRequestPrefillTag prefillTag = new BoxSignRequestPrefillTag(prefillTagJSON.asObject());
                            prefillTags.add(prefillTag);
                        }
                        this.prefillTags = prefillTags;
                        break;
                    }
                    case "days_valid": {
                        this.daysValid = value.asInt();
                        break;
                    }
                    case "external_id": {
                        this.externalId = value.asString();
                        break;
                    }
                    case "prepare_url": {
                        this.prepareUrl = value.asString();
                        break;
                    }
                    case "signing_log": {
                        BoxFile file;
                        JsonObject signingLogJSON = value.asObject();
                        String fileID = signingLogJSON.get("id").asString();
                        BoxFile boxFile = file = new BoxFile(BoxSignRequest.this.getAPI(), fileID);
                        boxFile.getClass();
                        this.signingLog = boxFile.new BoxFile.Info(signingLogJSON);
                        break;
                    }
                    case "status": {
                        this.status = BoxSignRequestStatus.fromJSONString(value.asString());
                        break;
                    }
                    case "sign_files": {
                        JsonObject signFilesJSON = value.asObject();
                        JsonValue filesArray = signFilesJSON.get("files");
                        List<BoxFile.Info> signFiles = this.getFiles(filesArray);
                        boolean isReadyForDownload = signFilesJSON.get("is_ready_for_download").asBoolean();
                        this.signFiles = new BoxSignRequestSignFiles(signFiles, isReadyForDownload);
                        break;
                    }
                    case "auto_expire_at": {
                        this.autoExpireAt = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "redirect_url": {
                        this.redirectUrl = value.asString();
                        break;
                    }
                    case "declined_redirect_url": {
                        this.declinedRedirectUrl = value.asString();
                        break;
                    }
                    case "template_id": {
                        this.templateId = value.asString();
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }

        private List<BoxFile.Info> getFiles(JsonValue filesArray) {
            ArrayList<BoxFile.Info> files = new ArrayList<BoxFile.Info>();
            for (JsonValue fileJSON : filesArray.asArray()) {
                BoxFile file;
                String fileID = fileJSON.asObject().get("id").asString();
                BoxFile boxFile = file = new BoxFile(BoxSignRequest.this.getAPI(), fileID);
                boxFile.getClass();
                files.add(boxFile.new BoxFile.Info(fileJSON.asObject()));
            }
            return files;
        }

        public class BoxSignRequestSignFiles {
            private final List<BoxFile.Info> files;
            private final boolean isReadyToDownload;

            public BoxSignRequestSignFiles(List<BoxFile.Info> files, boolean isReadyToDownload) {
                this.files = files;
                this.isReadyToDownload = isReadyToDownload;
            }

            public List<BoxFile.Info> getFiles() {
                return this.files;
            }

            public boolean getIsReadyToDownload() {
                return this.isReadyToDownload;
            }
        }
    }

    public static enum BoxSignRequestStatus {
        Converting("converting"),
        Created("created"),
        Sent("sent"),
        Viewed("viewed"),
        Signed("signed"),
        Cancelled("cancelled"),
        Declined("declined"),
        ErrorConverting("error_converting"),
        ErrorSending("error_sending"),
        Expired("expired"),
        Finalizing("finalizing"),
        ErrorFinalizing("error_finalizing");

        private final String jsonValue;

        private BoxSignRequestStatus(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static BoxSignRequestStatus fromJSONString(String jsonValue) {
            switch (jsonValue) {
                case "converting": {
                    return Converting;
                }
                case "created": {
                    return Created;
                }
                case "sent": {
                    return Sent;
                }
                case "viewed": {
                    return Viewed;
                }
                case "signed": {
                    return Signed;
                }
                case "cancelled": {
                    return Cancelled;
                }
                case "declined": {
                    return Declined;
                }
                case "error_converting": {
                    return ErrorConverting;
                }
                case "error_sending": {
                    return ErrorSending;
                }
                case "expired": {
                    return Expired;
                }
                case "finalizing": {
                    return Finalizing;
                }
                case "error_finalizing": {
                    return ErrorFinalizing;
                }
            }
            throw new IllegalArgumentException("The provided JSON value isn't a valid BoxSignRequestStatus value.");
        }
    }
}

