/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxEnterprise;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@BoxResourceType(value="terms_of_service")
public class BoxTermsOfService
extends BoxResource {
    public static final URLTemplate TERMS_OF_SERVICE_URL_TEMPLATE = new URLTemplate("terms_of_services/%s");
    public static final URLTemplate ALL_TERMS_OF_SERVICES_URL_TEMPLATE = new URLTemplate("terms_of_services");

    public BoxTermsOfService(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info create(BoxAPIConnection api, TermsOfServiceStatus termsOfServiceStatus, TermsOfServiceType termsOfServiceType, String text) {
        URL url = ALL_TERMS_OF_SERVICES_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        JsonObject requestJSON = new JsonObject().add("status", termsOfServiceStatus.toString()).add("tos_type", termsOfServiceType.toString()).add("text", text);
        request.setBody(requestJSON.toString());
        try (BoxJSONResponse response = request.send();){
            BoxTermsOfService createdTermsOfServices;
            JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
            BoxTermsOfService boxTermsOfService = createdTermsOfServices = new BoxTermsOfService(api, responseJSON.get("id").asString());
            boxTermsOfService.getClass();
            Info info = boxTermsOfService.new Info(responseJSON);
            return info;
        }
    }

    public static List<Info> getAllTermsOfServices(BoxAPIConnection api) {
        return BoxTermsOfService.getAllTermsOfServices(api, null);
    }

    public static List<Info> getAllTermsOfServices(BoxAPIConnection api, TermsOfServiceType termsOfServiceType) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (termsOfServiceType != null) {
            builder.appendParam("tos_type", termsOfServiceType.toString());
        }
        URL url = ALL_TERMS_OF_SERVICES_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "GET");
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
            int totalCount = responseJSON.get("total_count").asInt();
            ArrayList<Info> termsOfServices = new ArrayList<Info>(totalCount);
            JsonArray entries = responseJSON.get("entries").asArray();
            for (JsonValue value : entries) {
                BoxTermsOfService termsOfService;
                JsonObject termsOfServiceJSON = value.asObject();
                BoxTermsOfService boxTermsOfService = termsOfService = new BoxTermsOfService(api, termsOfServiceJSON.get("id").asString());
                boxTermsOfService.getClass();
                Info info = boxTermsOfService.new Info(termsOfServiceJSON);
                termsOfServices.add(info);
            }
            ArrayList<Info> arrayList = termsOfServices;
            return arrayList;
        }
    }

    public void updateInfo(Info info) {
        URL url = TERMS_OF_SERVICE_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
            info.update(responseJSON);
        }
    }

    public Info getInfo() {
        URL url = TERMS_OF_SERVICE_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "GET");
        try (BoxJSONResponse response = request.send();){
            Info info = new Info(Json.parse(response.getJSON()).asObject());
            return info;
        }
    }

    public class Info
    extends BoxResource.Info {
        private TermsOfServiceStatus status;
        private String type;
        private TermsOfServiceType tosType;
        private BoxEnterprise enterprise;
        private String text;
        private Date createdAt;
        private Date modifiedAt;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxResource getResource() {
            return BoxTermsOfService.this;
        }

        public TermsOfServiceStatus getStatus() {
            return this.status;
        }

        public void setStatus(TermsOfServiceStatus status) {
            this.status = status;
            this.addPendingChange("status", status.toString());
        }

        public String getType() {
            return this.type;
        }

        public TermsOfServiceType getTosType() {
            return this.tosType;
        }

        public BoxEnterprise getEnterprise() {
            return this.enterprise;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
            this.addPendingChange("text", text);
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("status")) {
                    this.status = TermsOfServiceStatus.fromStatus(value.asString());
                } else if (memberName.equals("enterprise")) {
                    JsonObject jsonObject = value.asObject();
                    this.enterprise = new BoxEnterprise(jsonObject);
                } else if (memberName.equals("type")) {
                    this.type = value.asString();
                } else if (memberName.equals("tos_type")) {
                    this.tosType = TermsOfServiceType.fromTosType(value.asString());
                } else if (memberName.equals("text")) {
                    this.text = value.asString();
                } else if (memberName.equals("created_at")) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("modified_at")) {
                    this.modifiedAt = BoxDateFormat.parse(value.asString());
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }

    public static enum TermsOfServiceStatus {
        ENABLED("enabled"),
        DISABLED("disabled");

        private final String status;

        private TermsOfServiceStatus(String status) {
            this.status = status;
        }

        static TermsOfServiceStatus fromStatus(String status) {
            if (status.equals("enabled")) {
                return ENABLED;
            }
            if (status.equals("disabled")) {
                return DISABLED;
            }
            System.out.print("Invalid Terms of Service Status");
            return null;
        }

        public String toString() {
            return this.status;
        }
    }

    public static enum TermsOfServiceType {
        MANAGED("managed"),
        EXTERNAL("external");

        private final String tosType;

        private TermsOfServiceType(String tosType) {
            this.tosType = tosType;
        }

        static TermsOfServiceType fromTosType(String tosType) {
            if (tosType.equals("managed")) {
                return MANAGED;
            }
            if (tosType.equals("external")) {
                return EXTERNAL;
            }
            System.out.print("Invalid Terms of Service Type");
            return null;
        }

        public String toString() {
            return this.tosType;
        }
    }
}

