/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxEvent;
import com.box.sdk.EnterpriseEventsRequest;
import com.box.sdk.EventLog;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.box.api.BoxHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxEventLogsManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxEventLogsManager.class);
    private BoxAPIConnection boxConnection;

    public BoxEventLogsManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public List<BoxEvent> getEnterpriseEvents(String position, Date after, Date before, BoxEvent.EventType ... types) {
        try {
            LOG.debug("Getting all enterprise events occurring between {} and {} {}", new Object[]{after == null ? "unspecified date" : DateFormat.getDateTimeInstance().format(after), before == null ? "unspecified date" : DateFormat.getDateTimeInstance().format(before), position == null ? "" : " starting at " + position});
            BoxHelper.notNull(after, "after");
            BoxHelper.notNull(before, "before");
            if (types == null) {
                types = new BoxEvent.EventType[]{};
            }
            EnterpriseEventsRequest request = new EnterpriseEventsRequest();
            request.position(position).after(after).before(before).types(types);
            EventLog eventLog = EventLog.getEnterpriseEvents(this.boxConnection, request);
            ArrayList<BoxEvent> results = new ArrayList<BoxEvent>();
            for (BoxEvent event : eventLog) {
                results.add(event);
            }
            return results;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }
}

