/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.browse;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultProducer;

@UriEndpoint(firstVersion="1.3.0", scheme="browse", title="Browse", syntax="browse:name", remote=false, category={Category.CORE, Category.MONITORING})
public class BrowseEndpoint
extends DefaultEndpoint
implements BrowsableEndpoint {
    @UriPath(description="A name which can be any string to uniquely identify the endpoint")
    @Metadata(required=true)
    private String name;
    private List<Exchange> exchanges;
    private volatile Processor onExchangeProcessor;

    public BrowseEndpoint() {
    }

    public BrowseEndpoint(String uri, Component component) {
        super(uri, component);
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public List<Exchange> getExchanges() {
        if (this.exchanges == null) {
            this.exchanges = this.createExchangeList();
        }
        return this.exchanges;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new DefaultProducer(this){

            @Override
            public void process(Exchange exchange) throws Exception {
                BrowseEndpoint.this.onExchange(exchange);
            }
        };
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        this.onExchangeProcessor = processor;
        DefaultConsumer answer = new DefaultConsumer(this, processor);
        this.configureConsumer(answer);
        return answer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected List<Exchange> createExchangeList() {
        return new CopyOnWriteArrayList<Exchange>();
    }

    protected void onExchange(Exchange exchange) throws Exception {
        this.getExchanges().add(exchange);
        if (this.onExchangeProcessor != null) {
            this.onExchangeProcessor.process(exchange);
        }
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        this.exchanges = this.createExchangeList();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.exchanges != null) {
            this.exchanges.clear();
            this.exchanges = null;
        }
        super.doStop();
    }
}

