/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.processor.idempotent;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.service.ServiceSupport;

@Metadata(label="bean", description="Idempotent repository that uses Caffiene cache to store message ids.", annotations={"interfaceName=org.apache.camel.spi.IdempotentRepository"})
@Configurer(metadataOnly=true)
@ManagedResource(description="Caffeine based message id repository")
public class CaffeineIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    private Cache<String, Boolean> cache;
    @Metadata(description="Name of cache", defaultValue="CaffeineIdempotentRepository")
    private String cacheName;

    public CaffeineIdempotentRepository() {
        this(CaffeineIdempotentRepository.class.getSimpleName());
    }

    public CaffeineIdempotentRepository(String repositoryName) {
        this.cacheName = repositoryName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    @ManagedAttribute(description="The processor name")
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        if (this.cache.asMap().containsKey(key)) {
            return false;
        }
        this.cache.put(key, true);
        return true;
    }

    @Override
    public boolean confirm(String key) {
        return this.cache.asMap().containsKey(key);
    }

    @Override
    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        return this.cache.asMap().containsKey(key);
    }

    @Override
    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        this.cache.invalidate(key);
        return true;
    }

    @Override
    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.cache == null) {
            Caffeine<Object, Object> builder = Caffeine.newBuilder();
            this.cache = builder.build();
        }
    }

    @Override
    protected void doStop() throws Exception {
    }

    protected Cache getCache() {
        return this.cache;
    }
}

