/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.support.component.SendDynamicAwareSupport;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

abstract class DefaultCaffeineSendDynamicAware
extends SendDynamicAwareSupport {
    DefaultCaffeineSendDynamicAware() {
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    @Override
    public SendDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        Map<String, Object> properties = this.endpointProperties(exchange, uri);
        return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, properties, null);
    }

    @Override
    public String resolveStaticUri(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        Object action = exchange.getMessage().getHeader("CamelCaffeineAction");
        Object key = exchange.getMessage().getHeader("CamelCaffeineKey");
        Object keys = exchange.getMessage().getHeader("CamelCaffeineKeys");
        Object value = exchange.getMessage().getHeader("CamelCaffeineValue");
        if (action == null && key == null && keys == null && value == null) {
            String query;
            LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(entry.getProperties());
            copy.remove("action");
            copy.remove("key");
            copy.remove("keys");
            copy.remove("value");
            String u = entry.getUri();
            if (u.contains("?")) {
                u = StringHelper.before(u, "?");
            }
            if (!(query = URISupport.createQueryString(copy)).isEmpty()) {
                return u + "?" + query;
            }
            return u;
        }
        return null;
    }

    @Override
    public Processor createPreProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return ex -> {
            Object value;
            Object keys;
            Object key;
            Object action = entry.getProperties().get("action");
            if (action != null) {
                ex.getMessage().setHeader("CamelCaffeineAction", action);
            }
            if ((key = entry.getProperties().get("key")) != null) {
                ex.getMessage().setHeader("CamelCaffeineKey", key);
            }
            if ((keys = entry.getProperties().get("keys")) != null) {
                ex.getMessage().setHeader("CamelCaffeineKeys", key);
            }
            if ((value = entry.getProperties().get("value")) != null) {
                ex.getMessage().setHeader("CamelCaffeineValue", value);
            }
        };
    }

    @Override
    public Processor createPostProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return ex -> {
            ex.getMessage().removeHeader("CamelCaffeineAction");
            ex.getMessage().removeHeader("CamelCaffeineKey");
            ex.getMessage().removeHeader("CamelCaffeineKeys");
            ex.getMessage().removeHeader("CamelCaffeineValue");
        };
    }
}

