/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.data.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Geometry;
import com.datastax.dse.driver.api.core.data.geometry.LineString;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.api.core.data.geometry.Polygon;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultGeometry;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultLineString;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPoint;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPolygon;
import com.datastax.dse.driver.internal.core.data.geometry.DistanceSerializationProxy;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCPoint;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;

@Immutable
public class Distance
extends DefaultGeometry {
    private static final Pattern WKT_PATTERN = Pattern.compile("distance *\\( *\\( *([\\d\\.-]+) *([\\d+\\.-]+) *\\) *([\\d+\\.-]+) *\\)", 2);
    private final DefaultPoint center;
    private final double radius;

    @NonNull
    public static Distance fromWellKnownText(@NonNull String source) {
        Matcher matcher = WKT_PATTERN.matcher(source.trim());
        if (matcher.matches() && matcher.groupCount() == 3) {
            try {
                return new Distance(new DefaultPoint(Double.parseDouble(matcher.group(1)), Double.parseDouble(matcher.group(2))), Double.parseDouble(matcher.group(3)));
            }
            catch (NumberFormatException var3) {
                throw new IllegalArgumentException(String.format("Unable to parse %s", source));
            }
        }
        throw new IllegalArgumentException(String.format("Unable to parse %s", source));
    }

    public Distance(@NonNull Point center, double radius) {
        super((OGCGeometry)((DefaultPoint)center).getOgcGeometry());
        Preconditions.checkNotNull(center);
        Preconditions.checkArgument(radius >= 0.0, "Radius must be >= 0 (got %s)", (Object)radius);
        this.center = (DefaultPoint)center;
        this.radius = radius;
    }

    @NonNull
    public Point getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    @NonNull
    public String asWellKnownText() {
        return String.format("DISTANCE((%s %s) %s)", this.center.X(), this.center.Y(), this.radius);
    }

    @Override
    @NonNull
    public OGCGeometry getOgcGeometry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public ByteBuffer asWellKnownBinary() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public String asGeoJson() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Distance) {
            Distance that = (Distance)other;
            return Objects.equals(this.center, that.center) && this.radius == that.radius;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.center, this.radius);
    }

    @Override
    public boolean contains(@NonNull Geometry geometry) {
        return geometry instanceof Distance ? this.containsDistance((Distance)geometry) : (geometry instanceof Point ? this.containsPoint((Point)geometry) : (geometry instanceof LineString ? this.containsLineString((LineString)geometry) : (geometry instanceof Polygon ? this.containsPolygon((Polygon)geometry) : false)));
    }

    private boolean containsDistance(Distance distance) {
        return this.center.getOgcGeometry().distance((OGCGeometry)distance.center.getOgcGeometry()) + distance.radius <= this.radius;
    }

    private boolean containsPoint(Point point) {
        return this.containsOGCPoint(((DefaultPoint)point).getOgcGeometry());
    }

    private boolean containsLineString(LineString lineString) {
        MultiPath multiPath = (MultiPath)((DefaultLineString)lineString).getOgcGeometry().getEsriGeometry();
        return this.containsMultiPath(multiPath);
    }

    private boolean containsPolygon(Polygon polygon) {
        com.esri.core.geometry.Polygon multiPath = (com.esri.core.geometry.Polygon)((DefaultPolygon)polygon).getOgcGeometry().getEsriGeometry();
        return this.containsMultiPath((MultiPath)multiPath);
    }

    private boolean containsMultiPath(MultiPath multiPath) {
        int numPoints = multiPath.getPointCount();
        for (int i = 0; i < numPoints; ++i) {
            OGCPoint point = new OGCPoint(multiPath.getPoint(i), DefaultGeometry.SPATIAL_REFERENCE_4326);
            if (this.containsOGCPoint(point)) continue;
            return false;
        }
        return true;
    }

    private boolean containsOGCPoint(OGCPoint point) {
        return this.center.getOgcGeometry().distance((OGCGeometry)point) <= this.radius;
    }

    private Object writeReplace() {
        return new DistanceSerializationProxy(this);
    }
}

